% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/iq.R
\name{run_iq}
\alias{run_iq}
\title{Generates an Installation Qualification Report}
\usage{
run_iq(location)
}
\arguments{
\item{location}{The path to the desired output directory.  The IQ
reports and any associated files will be placed in this directory.}
}
\value{
The path to the output directory.  The directory
will contain a PDF report showing a summary of the results of the IQ. After
the function is run, review this report to ensure that all tests passed.
}
\description{
The \code{run_iq} function executes an
installation qualification (IQ)
on the currently installed \strong{sassy} packages, and generates a report
on the results. The IQ ensures that all \strong{sassy} packages
have been installed.
The results of the IQ will be placed in the supplied location.
}
\examples{
# Create a temp directory
tmp <- tempdir()

# Run the Installation Qualification
run_iq(tmp)
}
