% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/coleman_plot.R
\name{plot.coleman}
\alias{plot.coleman}
\title{Plot Model Fits for a 'coleman' Object}
\usage{
\method{plot}{coleman}(
  x,
  xlab = "Relative area (log transformed)",
  ylab = "Species richness",
  pch = 16,
  cex = 1.2,
  pcol = "black",
  cex.lab = 1.3,
  cex.axis = 1,
  lwd = 2,
  lcol1 = "black",
  lcol2 = "darkgrey",
  ModTitle = NULL,
  TiAdj = 0,
  TiLine = 0.5,
  cex.main = 1.5,
  ...
)
}
\arguments{
\item{x}{An object of class 'coleman'.}

\item{xlab}{Title for the x-axis.}

\item{ylab}{Title for the y-axis.}

\item{pch}{Plotting character (for points).}

\item{cex}{A numerical vector giving the amount by which plotting symbols
(points) should be scaled relative to the default.}

\item{pcol}{Colour of the points.}

\item{cex.lab}{The amount by which the the axis titles should be scaled
relative to the default.}

\item{cex.axis}{The amount by which the the axis labels should be scaled
relative to the default.}

\item{lwd}{Line width.}

\item{lcol1}{Line colour of the fitted model curve.}

\item{lcol2}{Line colour of the model standard deviation curves.}

\item{ModTitle}{Plot title (default is null, which equates to no main
title).}

\item{TiAdj}{Which way the plot title (if included) is justified.}

\item{TiLine}{Places the plot title (if included) this many lines outwards
from the plot edge.}

\item{cex.main}{The amount by which the the plot title (if included)
should be scaled relative to the default.}

\item{\dots}{Further graphical parameters (see
\code{\link[graphics]{par}},
\code{\link[graphics]{plot.default}},\code{\link[graphics]{title}},
\code{\link[graphics]{lines}}) may be supplied as arguments.}
}
\description{
S3 method for class 'coleman'. \code{plot.coleman} creates a
  plot for objects of class coleman, using the R base plotting framework.
}
\details{
The resultant plot contains the observed richness values with the
  model fit and confidence intervals. Following Wang et al. (2010), the
  model is rejected if more than a third of the observed data points fall
  beyond one standard deviation from the expected curve.
}
\examples{
data(cole_sim)
fit <- coleman(cole_sim[[1]], cole_sim[[2]])
plot(fit, ModTitle = "Hetfield")
}
