% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mle3d_svc.R
\name{mle3d_svc}
\alias{mle3d_svc}
\title{Maximum likelihood estimation of the parameters of a 3rd-order tensor normal distribution}
\usage{
mle3d_svc(
  value3d,
  Id3,
  Id4,
  Id5,
  subject,
  data_3d,
  eps,
  maxiter,
  startmatU2,
  startmatU3
)
}
\arguments{
\item{value3d}{from the formula value3d ~ Id3 + Id4 + Id5}

\item{Id3}{from the formula value3d ~ Id3 + Id4 + Id5}

\item{Id4}{from the formula value3d ~ Id3 + Id4 + Id5}

\item{Id5}{from the formula value3d ~ Id3 + Id4 + Id5}

\item{subject}{the replicate, also called individual}

\item{data_3d}{the name of the tensor data}

\item{eps}{the threshold in the stopping criterion for the iterative mle algorithm}

\item{maxiter}{the maximum number of iterations for the iterative mle algorithm}

\item{startmatU2}{the value of the second factor variance covariance matrix used for initialization}

\item{startmatU3}{the value of the third factor variance covariance matrix used for initialization,
i.e., startmatU3 together with startmatU2 are used to start the algorithm and obtain the initial estimate of
the first factor variance covariance matrix U1}
}
\description{
Maximum likelihood estimation for the parameters of a
3rd-order tensor normal distribution \strong{X}, which is characterized by
a doubly separable variance-covariance structure. In the general
case, which is the case considered here, three unstructured
factor variance-covariance matrices determine the covariability
of random tensor entries, depending on the row (one factor
matrix), the column (another factor matrix) and the edge (remaining
factor matrix) where two \strong{X}-entries are. In the required function, the
Id3, Id4 and Id5 variables correspond to the row, column and edge
subscripts, respectively; \dQuote{value3d} indicates the observed
variable.
}
\section{Output}{


\dQuote{Convergence}, TRUE or FALSE

\dQuote{Iter}, the number of iterations needed for the mle algorithm to converge

\dQuote{Xmeanhat}, the estimated mean tensor (i.e., the sample mean)

\dQuote{First}, the row subscript, or the second column in the data file

\dQuote{U1hat}, the estimated variance-covariance matrix for the rows

\dQuote{Standardized.U1hat}, the standardized estimated variance-covariance matrix for the rows; the standardization is performed by dividing each entry of U1hat by entry(1, 1) of U1hat

\dQuote{Second}, the column subscript, or the third column in the data file

\dQuote{U2hat}, the estimated variance-covariance matrix for the columns

\dQuote{Standardized.U2hat}, the standardized estimated variance-covariance matrix for the columns; the standardization is performed by multiplying each entry of U2hat by entry(1, 1) of U1hat

\dQuote{Third}, the edge subscript, or the fourth column in the data file

\dQuote{U3hat}, the estimated variance-covariance matrix for the edges

\dQuote{Shat}, the sample variance-covariance matrix computed from the vectorized data tensors
}

\section{Reference}{


Manceur AM, Dutilleul P. 2013. Maximum likelihood estimation for the tensor normal distribution:
Algorithm, minimum sample size, and empirical bias and dispersion.
Journal of Computational and Applied Mathematics 239: 37-49.
}

\examples{
output <- mle3d_svc(data3d$value3d, data3d$Id3, data3d$Id4, data3d$Id5, data3d$K, data_3d = data3d)
output

}
