% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AbsBiasSS.R
\name{AbsBiasSS}
\alias{AbsBiasSS}
\title{Compute the Absolute Mean Bias Skill Score}
\usage{
AbsBiasSS(
  exp,
  obs,
  ref = NULL,
  time_dim = "sdate",
  memb_dim = NULL,
  dat_dim = NULL,
  na.rm = FALSE,
  sig_method.type = "two.sided.approx",
  alpha = 0.05,
  ncores = NULL
)
}
\arguments{
\item{exp}{A named numerical array of the forecast with at least time 
dimension.}

\item{obs}{A named numerical array of the observation with at least time 
dimension. The dimensions must be the same as 'exp' except 'memb_dim' and 
'dat_dim'.}

\item{ref}{A named numerical array of the reference forecast data with at 
least time dimension. The dimensions must be the same as 'exp' except
'memb_dim' and 'dat_dim'. If there is only one reference dataset, it should
not have dataset dimension. If there is corresponding reference for each
experiement, the dataset dimension must have the same length as in 'exp'. If
'ref' is NULL, the climatological forecast is used as reference forecast.
The default value is NULL.}

\item{time_dim}{A character string indicating the name of the time dimension.
The default value is 'sdate'.}

\item{memb_dim}{A character string indicating the name of the member dimension
to compute the ensemble mean; it should be set to NULL if the parameter 'exp'
and 'ref' are already the ensemble mean. The default value is NULL.}

\item{dat_dim}{A character string indicating the name of dataset dimension. 
The length of this dimension can be different between 'exp' and 'obs'. 
The default value is NULL.}

\item{na.rm}{A logical value indicating if NAs should be removed (TRUE) or
kept (FALSE) for computation. The default value is FALSE.}

\item{sig_method.type}{A character string indicating the test type of the
significance method. Check \code{RandomWalkTest()} parameter 
\code{test.type} for details. The default is 'two.sided.approx', which is 
the default of \code{RandomWalkTest()}.}

\item{alpha}{A numeric of the significance level to be used in the statistical
significance test. The default value is 0.05.}

\item{ncores}{An integer indicating the number of cores to use for parallel 
computation. The default value is NULL.}
}
\value{
\item{$biasSS}{
 A numerical array of BiasSS with dimensions nexp, nobs and the rest 
 dimensions of 'exp' except 'time_dim' and 'memb_dim'.
}
\item{$sign}{
 A logical array of the statistical significance of the BiasSS
 with the same dimensions as $biasSS. nexp is the number of 
 experiment (i.e., 'dat_dim' in exp), and nobs is the number of observation 
 (i.e., 'dat_dim' in obs). If dat_dim is NULL, nexp and nobs are omitted.
}
}
\description{
The Absolute Mean Bias Skill Score is based on the Absolute Mean Error (Wilks,
2011) between the ensemble mean forecast and the observations. It measures 
the accuracy of the forecast in comparison with a reference forecast to assess
whether the forecast presents an improvement or a worsening with respect to 
that reference. The Mean Bias Skill Score ranges between minus infinite and 1.
Positive values indicate that the forecast has higher skill than the reference
forecast, while negative values indicate that it has a lower skill. Examples
of reference forecasts are the climatological forecast (average of the 
observations), a previous model version, or another model. It is computed as
\code{AbsBiasSS = 1 - AbsBias_exp / AbsBias_ref}. The statistical significance
is obtained based on a Random Walk test at the confidence level specified
(DelSole and Tippett, 2016). If there is more than one dataset, the result 
will be computed for each pair of exp and obs data.
}
\examples{
exp <- array(rnorm(1000), dim = c(dat = 1, lat = 3, lon = 5, member = 10, sdate = 50))
ref <- array(rnorm(1000), dim = c(dat = 1, lat = 3, lon = 5, member = 10, sdate = 50))
obs <- array(rnorm(1000), dim = c(dat = 1, lat = 3, lon = 5, sdate = 50))
biasSS1 <- AbsBiasSS(exp = exp, obs = obs, ref = ref, memb_dim = 'member')
biasSS2 <- AbsBiasSS(exp = exp, obs = obs, ref = NULL, memb_dim = 'member')

}
\references{
Wilks, 2011; https://doi.org/10.1016/B978-0-12-385022-5.00008-7
DelSole and Tippett, 2016; https://doi.org/10.1175/MWR-D-15-0218.1
}
