% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gaussfit.R
\name{gauss3func}
\alias{gauss3func}
\title{Three Gaussian Absorption Features}
\usage{
gauss3func(x, a1, a2, a3, mu1, mu2, mu3, sig1, sig2, sig3)
}
\arguments{
\item{x}{the vector of values at which to evaluate}

\item{a1}{the amplitude of the first feature}

\item{a2}{the amplitude of the second feature}

\item{a3}{the amplitude of the third feature}

\item{mu1}{the center of the first feature}

\item{mu2}{the center of the second feature}

\item{mu3}{the center of the third feature}

\item{sig1}{the spread of the first feature (must be greater than 0)}

\item{sig2}{the spread of the second feature (must be greater than 0)}

\item{sig3}{the spread of the third feature (must be greater than 0)}
}
\value{
vector of values of the three specified inverted Gaussians
}
\description{
This function returns three Gaussian absorption features, both with continuum
1.0 and each with a specified amplitude, center, and spread.
}
\examples{
x = seq(5000, 5003, length.out=200)
y = gauss3func(x, 0.3, 0.5, 0.4, 5001.5, 5002, 5000.4, 0.1, 0.1, 0.13)
plot(x, y)

}
