% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/draws.R
\name{prob}
\alias{prob}
\alias{prob.rvec_lgl}
\alias{prob.logical}
\title{Calculate Probabilities from Random Draws}
\usage{
prob(x, na_rm = FALSE)

\method{prob}{rvec_lgl}(x, na_rm = FALSE)

\method{prob}{logical}(x, na_rm = FALSE)
}
\arguments{
\item{x}{An object of class \link[=rvec_lgl]{rvec_lgl}.}

\item{na_rm}{Whether to remove NAs before
calculating summaries. Default is \code{FALSE}.}
}
\value{
A logical vector with the same
length as \code{x}.
}
\description{
Convert an rvec of logical values (an \link[=rvec_lgl]{rvec_lgl})
into a vector of probabilities.
}
\details{
\code{prob()} is essentially just \code{\link[=draws_mean]{draws_mean()}}
with a different name. The proportion of
draws that are \code{TRUE} is used as an estimate of the
underlying probability. The different name
can make the intent of the code clearer.
}
\examples{
m <- rbind(c(FALSE,  TRUE),
           c(TRUE,   TRUE),
           c(FALSE,  FALSE))
x <- rvec(m)
x
prob(x)

## logical rvec created on the fly
## through operations such as '>'
m <- rbind(c(-1,  1.3, 2),
           c(2, 0.1, -1),
           c(Inf, 0, -0.5))
y <- rvec(m)
y
prob(y > 0)
prob(y >= 0)
prob(y^2 > 0)
}
\seealso{
\itemize{
\item \code{\link[=draws_mean]{draws_mean()}} Means across draws. Gives
the same result as \code{prob} when applied
to logical rvecs.
}
}
