% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/metadata_retrieval.R
\name{metadata_retrieval}
\alias{metadata_retrieval}
\title{SCOPUS Citation Retrieval}
\usage{
metadata_retrieval(query = NULL, view = c("STANDARD", "COMPLETE"), ...)
}
\arguments{
\item{query}{Query to run, not overall query, but `queryParam` query}

\item{view}{Type of view to have.  See
\url{https://dev.elsevier.com/guides/ArticleMetadataViews.htm}}

\item{...}{Arguments to be passed to \code{\link{generic_elsevier_api}}}
}
\value{
List of elements, similar to \code{\link{generic_elsevier_api}}
}
\description{
SCOPUS Citation Retrieval
}
\examples{
api_key = get_api_key(NULL, error = FALSE)
if (!is.null(api_key)){
   x = metadata_retrieval(query = "heart attack",
   verbose = FALSE)
}
}
\seealso{
\code{\link{generic_elsevier_api}},
\url{https://dev.elsevier.com/documentation/ArticleMetadataAPI.wadl}
}
