% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lint-framework.R
\name{linter}
\alias{linter}
\title{Create a Linter}
\usage{
linter(apply, takes, message, suggestion)
}
\arguments{
\item{apply}{Function that, given the content of a file, returns the indices
at which problems were found.}

\item{takes}{Function that, given a set of paths, returns the subset of
paths that this linter uses.}

\item{message}{Function that, given content and lines, returns an
informative message for the user. Typically generated with
\code{\link{makeLinterMessage}}.}

\item{suggestion}{String giving a prescribed fix for the linted problem.}
}
\description{
Generate a linter, which can identify errors or problematic regions in a
project.
}
\examples{
addLinter("no.capitals", linter(

  ## Identify lines containing capital letters -- either by name or by index
  apply = function(content, ...) {
    grep("[A-Z]", content)
  },

  ## Only use this linter on R files (paths ending with .r or .R)
  takes = function(paths) {
    grep("[rR]$", paths)
  },

  # Use the default message constructor
  message = function(content, lines, ...) {
    makeLinterMessage("Capital letters found on the following lines", content, lines)
  },

  # Give a suggested prescription
  suggest = "Do not use capital letters in these documents."
))
}

