% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dim_reduction.R
\name{remove_missing_values}
\alias{remove_missing_values}
\title{Remove Missing Values}
\usage{
remove_missing_values(
  tomic,
  value_var = NULL,
  missing_val_method = "drop_samples",
  verbose = TRUE
)
}
\arguments{
\item{tomic}{Either a \code{tidy_omic} or \code{triple_omic} object}

\item{value_var}{An abundance value to use with \code{hclust}}

\item{missing_val_method}{Approach to remove missing values:
\describe{
  \item{drop_features}{Drop features with missing values}
  \item{drop_samples}{Drop samples which are missing all features,
    then drop features}
  \item{impute}{Impute missing values}
}}

\item{verbose}{extra reporting messages}
}
\value{
A \code{tomic} object where missing values have been accounted
  for.
}
\description{
Account for missing values by dropping features, samples or using
  imputation.
}
\examples{
remove_missing_values(brauer_2008_triple)

}
