% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lcd.R
\name{lcd}
\alias{lcd}
\title{Local Climitalogical Data from NOAA}
\usage{
lcd(station, year, ...)
}
\arguments{
\item{station}{(character) station code, e.g., "02413099999". we will
allow integer/numeric passed here, but station ids can have leading
zeros, so it's a good idea to keep stations as character class}

\item{year}{(integer) year, e.g., 2017}

\item{...}{curl options passed on to \code{\link[crul]{HttpClient}}}
}
\value{
a data.frame, with many columns, and variable rows
depending on how frequently data was collected in the given year

a data.frame with many columns. the first 10 are metadata:

\itemize{
 \item station
 \item date
 \item source
 \item latitude
 \item longitude
 \item elevation
 \item name
 \item report_type
 \item call_sign
 \item quality_control
}

And the rest should be all data columns. See Note about data joined
together.
}
\description{
Local Climitalogical Data from NOAA
}
\note{
Beware that there are multiple columns with comma-delimited data 
joined together. In the next version of this package we'll try to have the
data cleaning done for you.
}
\examples{
\dontrun{
lcd(station = "01338099999", year = "2017")
lcd(station = "01338099999", year = "2015")

lcd(station = "02413099999", year = "2009")
lcd(station = "02413099999", year = "2001")

# pass curl options
lcd(station = "02413099999", year = "2002", verbose = TRUE)
}
}
\references{
\url{https://www.ncdc.noaa.gov/cdo-web/datatools/lcd}
\url{https://www1.ncdc.noaa.gov/pub/data/cdo/documentation/LCD_documentation.pdf}
}
