% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/params.R
\name{nassqs_params}
\alias{nassqs_params}
\title{Return list of NASS QS parameters.}
\usage{
nassqs_params(...)
}
\arguments{
\item{...}{a parameter, series of parameters, or a list of parameters that
you would like a description of. If missing, a list of all available
parameters is returned.}
}
\value{
a list of all available parameters or a description of a subset
}
\description{
Contains a simple hard-coded list of all available parameters. If no
parameter name is provided, returns a list of all parameters. More
information can be found in the API documentation on parameters found at
\url{https://quickstats.nass.usda.gov/api#param_define}.
}
\examples{
# Get a list of all available parameters
nassqs_params()

# Get information about specific parameters
nassqs_params("source_desc", "group_desc")
}
