% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rmw_do_all.R
\name{rmw_do_all}
\alias{rmw_do_all}
\title{Function to train a random forest model to predict (usually) pollutant
concentrations using meteorological and time variables and then immediately
normalise a variable for "average" meteorological conditions.}
\usage{
rmw_do_all(df, variables, n_trees = 300, min_node_size = 5, mtry = NULL,
  n_samples = 300, replace = TRUE, n_cores = NA, verbose = FALSE)
}
\arguments{
\item{df}{Input data frame after preparation with 
\code{\link{rmw_prepare_data}}. \code{df} has a number of constraints which 
will be checked for before modelling.}

\item{variables}{Independent/explanatory variables used to predict 
\code{"value"}.}

\item{n_trees}{Number of trees to grow to make up the forest.}

\item{min_node_size}{Minimal node size.}

\item{mtry}{Number of variables to possibly split at in each node. Default is 
the (rounded down) square root of the number variables.}

\item{n_samples}{Number of times to sample \code{df} and then predict?}

\item{replace}{Should \code{variables} be sampled with replacement?}

\item{n_cores}{Number of CPU cores to use for the model calculation. Default
is system's total minus one.}

\item{verbose}{Should the function give messages?}
}
\value{
Named list.
}
\description{
\code{rmw_do_all} is a user-level function to conduct the meteorological 
normalisation process in one step.
}
\examples{

\donttest{

# Keep things reproducible
set.seed(123)

# Prepare example data
data_london_prepared <- rmw_prepare_data(data_london, value = "no2")

# Use the example data to conduct the steps needed for meteorological
# normalisation
list_normalised <- rmw_do_all(
  df = data_london_prepared,
  variables = c(
    "ws", "wd", "air_temp", "rh", "date_unix", "day_julian", "weekday", "hour"
  ),
  n_trees = 300,
  n_samples = 300
)

}

}
\seealso{
\code{\link{rmw_prepare_data}},  \code{\link{rmw_train_model}}, 
\code{\link{rmw_normalise}}
}
\author{
Stuart K. Grange
}
