/*
 * Decompiled with CFR 0.152.
 */
package dmLab.utils;

import java.util.Arrays;
import java.util.Random;

public class MathUtils {
    private static Random rn = new Random();

    public static double log(double x, double a) {
        return Math.log(x) / Math.log(a);
    }

    public static double log2(double x) {
        return Math.log(x) / Math.log(2.0);
    }

    public static double sum(double[] array) {
        double sum = 0.0;
        int i = 0;
        while (i < array.length) {
            sum += array[i];
            ++i;
        }
        return sum;
    }

    public static float sum(float[] array) {
        float sum = 0.0f;
        int i = 0;
        while (i < array.length) {
            sum += array[i];
            ++i;
        }
        return sum;
    }

    public static int sum(int[] array) {
        int sum = 0;
        int i = 0;
        while (i < array.length) {
            sum += array[i];
            ++i;
        }
        return sum;
    }

    public static double mean(double[] array) {
        return MathUtils.mean(array, 0, array.length);
    }

    public static double mean(double[] array, int start, int stop) {
        if (stop > array.length || stop <= start) {
            return Double.NaN;
        }
        double sum = 0.0;
        int size = 0;
        int i = start;
        while (i < stop) {
            if (!Double.isNaN(array[i])) {
                sum += array[i];
                ++size;
            }
            ++i;
        }
        return sum / (double)size;
    }

    public static double median(double[] array) {
        double[] arrayTmp = (double[])array.clone();
        Arrays.sort(arrayTmp);
        double median = arrayTmp.length % 2 == 0 ? (arrayTmp[arrayTmp.length / 2] + arrayTmp[arrayTmp.length / 2 - 1]) / 2.0 : arrayTmp[arrayTmp.length / 2];
        return median;
    }

    public static double stdev(double[] array) {
        return Math.sqrt(MathUtils.variance(array));
    }

    public static double variance(double[] array) {
        if (array.length <= 1) {
            return 0.0;
        }
        double avg = MathUtils.mean(array);
        double sum = 0.0;
        int i = 0;
        while (i < array.length) {
            sum += Math.pow(array[i] - avg, 2.0);
            ++i;
        }
        return sum /= (double)array.length - 1.0;
    }

    public static double entropy(double[] array, boolean normalize) {
        if (array.length == 1) {
            return 0.0;
        }
        double entrophy = 0.0;
        double sum = 0.0;
        int i = 0;
        while (i < array.length) {
            sum += array[i];
            ++i;
        }
        i = 0;
        while (i < array.length) {
            double temp = array[i] / sum;
            if (temp > 0.0) {
                entrophy -= temp * MathUtils.log2(temp);
            }
            ++i;
        }
        if (normalize) {
            entrophy /= MathUtils.log2(array.length);
        }
        return entrophy;
    }

    public static double newton(double n, double k) {
        double newton = 1.0;
        int i = 0;
        while ((double)i < k) {
            double d = n;
            n = d - 1.0;
            double d2 = k;
            k = d2 - 1.0;
            newton *= d / d2;
            ++i;
        }
        return newton;
    }

    public static int rand(int lo, int hi) {
        int n = hi - lo + 1;
        int i = rn.nextInt() % n;
        if (i < 0) {
            i = -i;
        }
        return lo + i;
    }

    public static float maxValue(float[] array) {
        if (array.length == 0) {
            return -1.0f;
        }
        float maxVal = array[0];
        int i = 1;
        while (i < array.length) {
            if (array[i] > maxVal) {
                maxVal = array[i];
            }
            ++i;
        }
        return maxVal;
    }

    public static float minValue(float[] array) {
        if (array.length == 0) {
            return -1.0f;
        }
        float minVal = array[0];
        int i = 1;
        while (i < array.length) {
            if (array[i] < minVal) {
                minVal = array[i];
            }
            ++i;
        }
        return minVal;
    }

    public static float mathOperation(float val1, float val2, String operator) {
        if (operator.equalsIgnoreCase("+")) {
            return val1 + val2;
        }
        if (operator.equalsIgnoreCase("-")) {
            return val1 - val2;
        }
        if (operator.equalsIgnoreCase("*")) {
            return val1 * val2;
        }
        if (operator.equalsIgnoreCase("/")) {
            return val1 / val2;
        }
        if (operator.equalsIgnoreCase("^")) {
            return (float)Math.pow(val1, val2);
        }
        return Float.NaN;
    }

    public static double truncate(double x, int digits) {
        double mult = Math.pow(10.0, digits);
        int intX = (int)(x * mult);
        return (double)intX / mult;
    }
}

