/*
 * Decompiled with CFR 0.152.
 */
package dmLab.utils.dataframe;

import dmLab.utils.ArrayUtils;
import dmLab.utils.MathUtils;
import dmLab.utils.dataframe.Column;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;

public final class DataFrame
implements Cloneable {
    private Column[] columns;
    private Object[][] data;
    private HashMap<String, Integer> colNamesMap;

    protected DataFrame() {
    }

    /*
     * WARNING - void declaration
     */
    public DataFrame(int rows, int cols) {
        void var2_2;
        void var1_1;
        this.init((int)var1_1, (int)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public DataFrame(int rows, String[] colNames) {
        void var2_2;
        void var1_1;
        this.init((int)var1_1, colNames.length);
        this.setColNames((String[])var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public DataFrame(int rows, DataFrame df) {
        void var2_3;
        void var1_1;
        DataFrame dataFrame = df;
        this.init((int)var1_1, dataFrame.data[0].length);
        dataFrame = var2_3;
        this.setColumns(dataFrame.columns);
    }

    /*
     * WARNING - void declaration
     */
    private void init(int rows, int cols) {
        this.columns = new Column[cols];
        this.data = new Object[rows][cols];
        this.colNamesMap = new HashMap();
        int i = 0;
        while (i < this.columns.length) {
            void var2_3;
            String colName = "x" + i;
            this.columns[i] = new Column(colName, 0);
            this.colNamesMap.put((String)var2_3, i);
            ++i;
        }
    }

    private void initColNamesMap() {
        this.colNamesMap = new HashMap();
        int i = 0;
        while (i < this.columns.length) {
            this.colNamesMap.put(this.columns[i].name, i);
            ++i;
        }
    }

    private boolean setColumns(Column[] cols) {
        if (cols.length != this.columns.length) {
            return false;
        }
        this.colNamesMap = new HashMap();
        int i = 0;
        while (i < this.columns.length) {
            this.columns[i].name = cols[i].name;
            this.columns[i].type = cols[i].type;
            this.colNamesMap.put(cols[i].name, i);
            ++i;
        }
        return true;
    }

    public final boolean setColNames(String[] colNames) {
        if (colNames.length != this.columns.length) {
            return false;
        }
        this.colNamesMap = new HashMap();
        int i = 0;
        while (i < this.columns.length) {
            this.columns[i].name = colNames[i];
            this.colNamesMap.put(colNames[i], i);
            ++i;
        }
        return true;
    }

    public final boolean setColTypes(short[] colTypes) {
        if (colTypes.length != this.columns.length) {
            return false;
        }
        int i = 0;
        while (i < this.columns.length) {
            this.columns[i].type = colTypes[i];
            ++i;
        }
        return true;
    }

    /*
     * WARNING - void declaration
     */
    public final String[] getColNames() {
        void var1_1;
        String[] colNames = new String[this.columns.length];
        int i = 0;
        while (i < this.columns.length) {
            colNames[i] = this.columns[i].name;
            ++i;
        }
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public final int getColIdx(String colName) {
        void var1_1;
        Integer n = this.colNamesMap.get(colName);
        if (n == null) {
            return -1;
        }
        return this.colNamesMap.get(var1_1);
    }

    public final int getFirstRowIdx(int col, Object cell) {
        int i = 0;
        while (i < this.data.length) {
            if (this.data[i][col].equals(cell)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public final boolean setColumn(int col, float[] cells) {
        DataFrame dataFrame = this;
        if (dataFrame.data.length != cells.length) {
            return false;
        }
        dataFrame = this;
        int size = dataFrame.data.length;
        int i = 0;
        while (i < size) {
            this.data[i][col] = Float.valueOf(cells[i]);
            ++i;
        }
        return true;
    }

    public final boolean setColumn(int col2, String[] cells) {
        DataFrame col2 = this;
        if (col2.data.length != cells.length) {
            return false;
        }
        col2 = this;
        int size = col2.data.length;
        int i = 0;
        while (i < size) {
            this.data[i][0] = cells[i];
            ++i;
        }
        return true;
    }

    /*
     * WARNING - void declaration
     */
    public final boolean set(int row, int col, Object cellValue) {
        void var3_3;
        this.data[var1_1][var2_2] = var3_3;
        return true;
    }

    /*
     * WARNING - void declaration
     */
    public final Object get(int row, int col) {
        void var2_2;
        void var1_1;
        return this.data[var1_1][var2_2];
    }

    public final Object[] getColumn(int col) {
        DataFrame dataFrame = this;
        Object[] column = new Object[dataFrame.data.length];
        int i = 0;
        while (i < column.length) {
            column[i] = this.data[i][col];
            ++i;
        }
        return dataFrame;
    }

    /*
     * WARNING - void declaration
     */
    public final Object[] getRow(int row) {
        void var1_1;
        return this.data[var1_1];
    }

    public final DataFrame excludeRows(int[] rows) {
        DataFrame dataFrame = this;
        if (1 > dataFrame.data.length) {
            return null;
        }
        HashSet<Integer> rowset = new HashSet<Integer>(Arrays.asList(ArrayUtils.int2Integer(rows)));
        dataFrame = this;
        boolean[] filter = new boolean[dataFrame.data.length];
        int i = 0;
        while (i < filter.length) {
            filter[i] = !rowset.contains(i);
            ++i;
        }
        return this.filterRows((boolean[])dataFrame);
    }

    /*
     * WARNING - void declaration
     */
    private DataFrame filterRows(boolean[] filter) {
        void var2_4;
        DataFrame dataFrame = this;
        if (filter.length > dataFrame.data.length) {
            return null;
        }
        int size = ArrayUtils.count(filter, true);
        DataFrame df = new DataFrame(size, this);
        int dfRowIdx = 0;
        int i = 0;
        while (i < filter.length) {
            if (filter[i]) {
                int j = 0;
                while (j < this.columns.length) {
                    df.data[dfRowIdx][j] = this.data[i][j];
                    ++j;
                }
                ++dfRowIdx;
            }
            ++i;
        }
        return var2_4;
    }

    /*
     * WARNING - void declaration
     */
    public final String toString() {
        void var1_1;
        StringBuffer tmp = new StringBuffer();
        int i22 = 0;
        while (i22 < this.columns.length) {
            if (i22 > 0) {
                tmp.append(", ");
            }
            tmp.append(this.columns[i22].name);
            ++i22;
        }
        tmp.append('\n');
        DataFrame i22 = this;
        int rows = i22.data.length;
        int i = 0;
        while (i < rows) {
            int j = 0;
            while (j < this.columns.length) {
                if (this.data[i][j] != null) {
                    tmp.append(this.data[i][j]);
                }
                if (j < this.columns.length - 1) {
                    tmp.append(", ");
                } else {
                    tmp.append("\n");
                }
                ++j;
            }
            ++i;
        }
        return var1_1.toString();
    }

    public final boolean cbind(DataFrame df) {
        DataFrame dataFrame = this;
        DataFrame dataFrame2 = dataFrame;
        dataFrame2 = df;
        if (dataFrame.data.length != dataFrame2.data.length) {
            return false;
        }
        dataFrame2 = this;
        int rows = dataFrame2.data.length;
        dataFrame2 = this;
        int cols_old = dataFrame2.data[0].length;
        Column[] columns_old = (Column[])this.columns.clone();
        Object[][] data_old = (Object[][])this.data.clone();
        DataFrame dataFrame3 = this;
        dataFrame2 = dataFrame3;
        DataFrame dataFrame4 = this;
        dataFrame2 = dataFrame4;
        dataFrame2 = df;
        this.init(dataFrame3.data.length, dataFrame4.data[0].length + dataFrame2.data[0].length);
        dataFrame2 = this;
        int cols_new = dataFrame2.data[0].length;
        int j = 0;
        while (j < cols_new) {
            this.columns[j] = j < cols_old ? columns_old[j] : df.columns[j - cols_old];
            ++j;
        }
        this.initColNamesMap();
        int i = 0;
        while (i < rows) {
            int j2 = 0;
            while (j2 < cols_new) {
                this.data[i][j2] = j2 < cols_old ? data_old[i][j2] : df.data[i][j2 - cols_old];
                ++j2;
            }
            ++i;
        }
        return true;
    }

    public final boolean rbind(DataFrame df) {
        DataFrame dataFrame = this;
        DataFrame dataFrame2 = dataFrame;
        dataFrame2 = df;
        if (dataFrame.data[0].length != dataFrame2.data[0].length) {
            return false;
        }
        dataFrame2 = this;
        int rows_old = dataFrame2.data.length;
        dataFrame2 = this;
        int cols = dataFrame2.data[0].length;
        Column[] columns_old = (Column[])this.columns.clone();
        Object[][] data_old = (Object[][])this.data.clone();
        DataFrame dataFrame3 = this;
        dataFrame2 = dataFrame3;
        DataFrame dataFrame4 = df;
        dataFrame2 = dataFrame4;
        dataFrame2 = this;
        this.init(dataFrame3.data.length + dataFrame4.data.length, dataFrame2.data[0].length);
        this.setColumns(columns_old);
        dataFrame2 = this;
        int rows_new = dataFrame2.data.length;
        int i = 0;
        while (i < rows_new) {
            int j = 0;
            while (j < cols) {
                this.data[i][j] = i < rows_old ? data_old[i][j] : df.data[i - rows_old][j];
                ++j;
            }
            ++i;
        }
        return true;
    }

    public final boolean mathOperation(float value, String operator) {
        DataFrame dataFrame = this;
        int rows = dataFrame.data.length;
        dataFrame = this;
        int cols = dataFrame.data[0].length;
        int i = 0;
        while (i < rows) {
            int j = 0;
            while (j < cols) {
                if (this.columns[j].type == 1) {
                    this.data[i][j] = Float.valueOf(MathUtils.mathOperation(((Float)this.data[i][j]).floatValue(), value, operator));
                }
                ++j;
            }
            ++i;
        }
        return true;
    }

    public final boolean mathOperation(DataFrame df, String operator) {
        DataFrame dataFrame = this;
        DataFrame dataFrame2 = dataFrame;
        dataFrame2 = df;
        if (dataFrame.data[0].length != dataFrame2.data[0].length) {
            return false;
        }
        DataFrame dataFrame3 = this;
        dataFrame2 = dataFrame3;
        dataFrame2 = df;
        if (dataFrame3.data.length != dataFrame2.data.length) {
            return false;
        }
        dataFrame2 = this;
        int rows = dataFrame2.data.length;
        dataFrame2 = this;
        int cols = dataFrame2.data[0].length;
        int i = 0;
        while (i < rows) {
            int j = 0;
            while (j < cols) {
                if (this.columns[j].type == 1) {
                    this.data[i][j] = Float.valueOf(MathUtils.mathOperation(((Float)this.data[i][j]).floatValue(), ((Float)df.data[i][j]).floatValue(), operator));
                }
                ++j;
            }
            ++i;
        }
        return true;
    }

    public final int rows() {
        return this.data.length;
    }
}

