/*
 * Decompiled with CFR 0.152.
 */
package dmLab.utils.cmatrix;

import dmLab.array.functions.DiscFunctions;
import dmLab.utils.cmatrix.AccuracyMeasure;

public final class ConfusionMatrix {
    private String decision;
    private double[][] confusionMatrix;
    private String[] decValuesStr;
    private String[] decValuesStrDict;
    private float[] decValuesDbl;
    private boolean printAttrDictList;
    private int maxSize = 10;

    public final double[][] getMatrix() {
        return this.confusionMatrix;
    }

    /*
     * WARNING - void declaration
     */
    public ConfusionMatrix(String decision, float[] decisionValuesDbl, String[] decisionValuesStr) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.decision = var1_1;
        this.decValuesDbl = var2_2;
        this.decValuesStr = decisionValuesStr;
        this.decValuesStrDict = new String[((void)var3_3).length];
        this.printAttrDictList = false;
        this.createDecValuesStrDict();
        this.confusionMatrix = new double[this.decValuesDbl.length + 1][this.decValuesDbl.length + 1];
    }

    /*
     * WARNING - void declaration
     */
    public ConfusionMatrix(String decision, String[] decisionValuesStr) {
        void var2_2;
        void var1_1;
        this.decision = var1_1;
        this.decValuesDbl = null;
        this.decValuesStr = decisionValuesStr;
        this.decValuesStrDict = new String[decisionValuesStr.length];
        this.printAttrDictList = false;
        this.createDecValuesStrDict();
        this.confusionMatrix = new double[decisionValuesStr.length + 1][((void)var2_2).length + 1];
    }

    private void createDecValuesStrDict() {
        int i = 0;
        while (i < this.decValuesStrDict.length) {
            if (this.decValuesStr[i].length() < this.maxSize) {
                this.decValuesStrDict[i] = this.decValuesStr[i];
            } else {
                this.decValuesStrDict[i] = "val_" + i;
                this.printAttrDictList = true;
            }
            ++i;
        }
    }

    /*
     * WARNING - void declaration
     */
    private String labelsToString() {
        void var1_1;
        StringBuffer tmp = new StringBuffer();
        tmp.append("Captions:\n");
        int i = 0;
        while (i < this.decValuesStrDict.length) {
            if (!this.decValuesStrDict[i].equalsIgnoreCase(this.decValuesStr[i])) {
                tmp.append(String.valueOf(this.decValuesStrDict[i]) + "=" + this.decValuesStr[i]).append("\n");
            }
            ++i;
        }
        tmp.append("\n");
        return var1_1.toString();
    }

    /*
     * WARNING - void declaration
     */
    public final void add(double realDecision, double predictedDecision) {
        void var3_2;
        void var1_1;
        double[] dArray = this.confusionMatrix[this.findIndex((double)var1_1)];
        int n = this.findIndex((double)var3_2);
        dArray[n] = dArray[n] + 1.0;
    }

    /*
     * WARNING - void declaration
     */
    public final void add(String realDecision, String predictedDecision) {
        void var2_2;
        void var1_1;
        double[] dArray = this.confusionMatrix[this.findIndex((String)var1_1)];
        int n = this.findIndex((String)var2_2);
        dArray[n] = dArray[n] + 1.0;
    }

    public final void add(ConfusionMatrix SourceConfusionMatrix) {
        int i = 0;
        while (i < this.confusionMatrix.length) {
            int j = 0;
            while (j < this.confusionMatrix.length) {
                double[] dArray = this.confusionMatrix[i];
                int n = j;
                dArray[n] = dArray[n] + SourceConfusionMatrix.confusionMatrix[i][j];
                ++j;
            }
            ++i;
        }
    }

    private int findIndex(String decisionValue) {
        int i = 0;
        while (i < this.decValuesStr.length) {
            if (this.decValuesStr[i].equalsIgnoreCase(decisionValue)) {
                return i;
            }
            ++i;
        }
        return this.decValuesStr.length;
    }

    private int findIndex(double decisionValue) {
        if (decisionValue == -1.0) {
            return this.decValuesDbl.length;
        }
        int index = 0;
        while (index < this.decValuesDbl.length) {
            if ((double)this.decValuesDbl[index] == decisionValue) {
                return index;
            }
            ++index;
        }
        return this.decValuesDbl.length;
    }

    public final String toString() {
        return this.toString(true, false, true, "\t");
    }

    public final String toString(boolean header, boolean fullClassLabels, boolean showOther, String sep) {
        StringBuffer tmp = new StringBuffer();
        if (this.printAttrDictList && !fullClassLabels) {
            tmp.append(this.labelsToString());
        }
        if (header) {
            tmp.append("Confusion Matrix\n");
            tmp.append("\t\t\tpredicted\n");
        }
        String[] decValuesTmp = this.decValuesStrDict;
        if (fullClassLabels) {
            decValuesTmp = this.decValuesStr;
        }
        tmp.append(this.decision);
        int i = 0;
        while (i < decValuesTmp.length) {
            tmp.append(sep).append(decValuesTmp[i]);
            ++i;
        }
        if (showOther) {
            tmp.append(sep).append("other");
        }
        tmp.append("\n");
        int size = this.confusionMatrix.length;
        if (!showOther) {
            size = this.confusionMatrix.length - 1;
        }
        int i2 = 0;
        while (i2 < size) {
            if (i2 < decValuesTmp.length) {
                tmp.append(decValuesTmp[i2]);
            } else {
                tmp.append("other");
            }
            int j = 0;
            while (j < size) {
                tmp.append(sep).append("" + this.confusionMatrix[i2][j]);
                ++j;
            }
            tmp.append("\n");
            ++i2;
        }
        tmp.append("\n");
        return tmp.toString();
    }

    /*
     * WARNING - void declaration
     */
    public final String statsToString(int precision) {
        void var1_2;
        StringBuffer tmp = new StringBuffer();
        tmp.append("Accuracy = " + DiscFunctions.format(AccuracyMeasure.calcAcc(this.confusionMatrix), 4)).append("\n");
        tmp.append("WeightedAccuracy = " + DiscFunctions.format(AccuracyMeasure.calcWAcc(this.confusionMatrix), 4)).append("\n");
        tmp.append("True Positive Rate\n");
        int i = 0;
        while (i < this.decValuesStr.length) {
            tmp.append("\t" + this.decValuesStr[i] + ": " + DiscFunctions.format(AccuracyMeasure.calcTPRate(this.confusionMatrix, i), 4)).append("\n");
            ++i;
        }
        tmp.append("False Positive Rate\n");
        i = 0;
        while (i < this.decValuesStr.length) {
            tmp.append("\t" + this.decValuesStr[i] + ": " + DiscFunctions.format(AccuracyMeasure.calcFPRate(this.confusionMatrix, i), 4)).append("\n");
            ++i;
        }
        return var1_2.toString();
    }

    /*
     * WARNING - void declaration
     */
    public final float calcMeasure(int measure) {
        void var1_1;
        if (measure == AccuracyMeasure.ACC) {
            return (float)AccuracyMeasure.calcAcc(this.confusionMatrix);
        }
        if (var1_1 == AccuracyMeasure.WACC) {
            return (float)AccuracyMeasure.calcWAcc(this.confusionMatrix);
        }
        return Float.NaN;
    }

    public final void cleanMatrix() {
        this.confusionMatrix = new double[this.decValuesStr.length + 1][this.decValuesStr.length + 1];
    }
}

