/*
 * Decompiled with CFR 0.152.
 */
package dmLab.mcfs.attributesRI;

import dmLab.array.Array;
import dmLab.array.FArray;
import dmLab.array.functions.DiscFunctions;
import dmLab.classifier.attributeIndicators.AttributeIndicators;
import dmLab.mcfs.attributesRI.Dictionary;
import dmLab.mcfs.attributesRI.ExperimentIndicators;
import dmLab.mcfs.attributesRI.Ranking;
import dmLab.mcfs.attributesRI.measuresRI.Importance;
import dmLab.mcfs.attributesRI.measuresRI.ImportanceMeasure;
import dmLab.mcfs.attributesRI.measuresRI.NodesMeasure;
import dmLab.utils.ArrayUtils;
import dmLab.utils.list.StringList;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;

public final class AttributesRI {
    public String label = "";
    public int mainMeasureIdx = -1;
    private ArrayList<ImportanceMeasure> measures;
    private HashMap<String, Integer> measureName;
    private float[][] importances = null;
    private Dictionary attrMap = new Dictionary();

    public AttributesRI() {
        this.measures = new ArrayList();
        this.measureName = new HashMap();
    }

    public AttributesRI(FArray array) {
        this();
        FArray fArray = array;
        int attrNumber = fArray.attributes.length;
        int decIndex = array.getDecAttrIdx();
        int i = 0;
        while (i < attrNumber) {
            if (i != decIndex) {
                this.attrMap.addItem(array.attributes[i].name);
            }
            ++i;
        }
    }

    public final void initImportances() {
        this.importances = new float[this.attrMap.size()][this.measures.size()];
    }

    /*
     * WARNING - void declaration
     */
    public final void addMeasure(ImportanceMeasure measure) {
        void var1_1;
        this.measures.add(measure);
        this.measureName.put(var1_1.name, this.measureName.size());
    }

    /*
     * WARNING - void declaration
     */
    public final boolean addImportances(String attributeName, ExperimentIndicators experimentIndicators, AttributeIndicators indicators) {
        void var3_3;
        void var2_2;
        int attributeIndex = this.attrMap.getItem(attributeName);
        if (attributeIndex == -1) {
            void var1_1;
            System.err.println("Attribute does not exist in the data. *****\n attributeName: " + (String)var1_1 + "\n experimentIndicators: " + experimentIndicators.toString() + "\n attributeIndicators: " + indicators.toString());
            return false;
        }
        this.addImportances(attributeIndex, (ExperimentIndicators)var2_2, (AttributeIndicators)var3_3);
        return true;
    }

    private void addImportances(int attributeIndex, ExperimentIndicators experimentIndicators, AttributeIndicators indicators) {
        int size = this.measures.size();
        int i = 0;
        while (i < size) {
            float[] fArray = this.importances[attributeIndex];
            int n = i;
            fArray[n] = (float)((double)fArray[n] + this.measures.get(i).calcAttrImportance(experimentIndicators, indicators));
            ++i;
        }
    }

    public final void addProjections(FArray array) {
        int decIndex = array.getDecAttrIdx();
        int measureIdx = this.getMeasureIndex(ImportanceMeasure.MEASURE_PROJECTIONS);
        ImportanceMeasure measure = this.measures.get(measureIdx);
        FArray fArray = array;
        int size = fArray.attributes.length;
        int i = 0;
        while (i < size) {
            if (i != decIndex) {
                int attributeIndex = this.attrMap.getItem(array.attributes[i].name);
                float[] fArray2 = this.importances[attributeIndex];
                int n = measureIdx;
                fArray2[n] = (float)((double)fArray2[n] + measure.calcAttrImportance());
            }
            ++i;
        }
    }

    public final boolean combineImportances(AttributesRI ri) {
        int size_attr = this.attrMap.size();
        if (size_attr != ri.attrMap.size()) {
            System.err.println("Destination AttributesRI size does not equal to the source AttributesRI size.");
            return false;
        }
        int size_m = this.measures.size();
        if (size_m != ri.measures.size()) {
            System.err.println("Destination AttributesRI measures number does not equal to the source AttributesRI measures number.");
            return false;
        }
        int i = 0;
        while (i < size_attr) {
            int j = 0;
            while (j < size_m) {
                float[] fArray = this.importances[i];
                int n = j;
                fArray[n] = fArray[n] + ri.importances[i][j];
                ++j;
            }
            ++i;
        }
        return true;
    }

    /*
     * WARNING - void declaration
     */
    public final int getMeasureIndex(String measureName) {
        void var2_2;
        Integer measureIndex = this.measureName.get(measureName);
        if (measureIndex == null) {
            void var1_1;
            System.err.print("Measure " + (String)var1_1 + " does not exist");
            return -1;
        }
        return var2_2.intValue();
    }

    public final void calcNormMeasure(int splits) {
        int measureProjectionsIdx = this.getMeasureIndex(ImportanceMeasure.MEASURE_PROJECTIONS);
        int measureRIIdx = this.getMeasureIndex(ImportanceMeasure.MEASURE_RI);
        int measureRINormIdx = this.getMeasureIndex(ImportanceMeasure.MEASURE_RINORM);
        AttributesRI attributesRI = this;
        int size = attributesRI.attrMap.size();
        int i = 0;
        while (i < size) {
            if (this.importances[i][measureProjectionsIdx] != 0.0f) {
                this.importances[i][measureRINormIdx] = this.importances[i][measureRIIdx] / (this.importances[i][measureProjectionsIdx] * (float)splits);
            }
            ++i;
        }
    }

    public final void flushMeasures() {
        int size = this.measures.size();
        int i = 0;
        while (i < size) {
            this.measures.get(i).flush();
            ++i;
        }
    }

    public final int getAttributesNumber() {
        return this.attrMap.size();
    }

    /*
     * WARNING - void declaration
     */
    public final String[] getMeasuresNames() {
        void var2_2;
        int size = this.measures.size();
        String[] array = new String[size];
        int i = 0;
        while (i < size) {
            array[i] = this.measures.get((int)i).name;
            ++i;
        }
        return var2_2;
    }

    /*
     * WARNING - void declaration
     */
    public final float getImportance(String attributeName, int measureIndex) {
        int index = this.attrMap.getItem(attributeName);
        if (index != -1) {
            void var2_3;
            void var1_2;
            return this.importances[var1_2][var2_3];
        }
        return Float.NaN;
    }

    /*
     * WARNING - void declaration
     */
    public final float[] getImportanceValues(int measureIndex) {
        void var2_2;
        float[] retVal = new float[this.importances.length];
        int i = 0;
        while (i < this.importances.length) {
            retVal[i] = this.importances[i][measureIndex];
            ++i;
        }
        return var2_2;
    }

    /*
     * WARNING - void declaration
     */
    public final Importance[] getImportances(int measureIndex) {
        void var3_3;
        int size = this.attrMap.size();
        Importance[] imp = new Importance[size];
        int i = 0;
        while (i < size) {
            int index = this.attrMap.getItem(this.attrMap.getItem(i));
            imp[i] = new Importance(this.attrMap.getItem(i), this.importances[index][measureIndex]);
            ++i;
        }
        return var3_3;
    }

    /*
     * WARNING - void declaration
     */
    public final float[] getMinMaxImportances(int measureIndex) {
        void var3_3;
        void var2_2;
        float minImportanceValue = this.importances[0][measureIndex];
        float maxImportanceValue = this.importances[0][measureIndex];
        int i = 0;
        while (i < this.importances.length) {
            float f;
            float importanceValue = this.importances[i][measureIndex];
            if (f > maxImportanceValue) {
                maxImportanceValue = importanceValue;
            }
            if (importanceValue < minImportanceValue) {
                minImportanceValue = importanceValue;
            }
            ++i;
        }
        return new float[]{var2_2, var3_3};
    }

    /*
     * WARNING - void declaration
     */
    public final Ranking getTopRanking(int measureIndex, float minRI) {
        int size = 0;
        int i = 0;
        while (i < this.importances.length) {
            if (this.importances[i][measureIndex] > minRI) {
                ++size;
            }
            ++i;
        }
        if (size != 0) {
            void var3_3;
            void var1_1;
            return this.getTopRankingSize((int)var1_1, (int)var3_3);
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    public final Ranking getTopRankingSize(int measureIndex, int size) {
        void var1_1;
        float[][] ranking = new float[this.importances.length][2];
        int i = 0;
        while (i < this.importances.length) {
            ranking[i][0] = i;
            ranking[i][1] = this.importances[i][measureIndex];
            ++i;
        }
        ArrayUtils.qSort(ranking, 1);
        Ranking rank = new Ranking(size);
        int i2 = this.importances.length - 1;
        int j = 0;
        while (i2 >= this.importances.length - size) {
            String attr = this.attrMap.getItem((int)ranking[i2][0]);
            rank.put(attr, ranking[i2][1], j);
            --i2;
            ++j;
        }
        rank.setMeasureName(this.measures.get((int)var1_1).name);
        return rank;
    }

    /*
     * WARNING - void declaration
     */
    public final boolean[] getColMask(Array container, int measureIndex, int filterSize, boolean inverseFiltering) {
        void var2_3;
        Ranking ranking = this.getTopRankingSize(measureIndex, filterSize);
        int columns = container.colsNumber();
        boolean[] colMask = new boolean[columns];
        Arrays.fill(colMask, inverseFiltering);
        int decisionIndex = container.getDecAttrIdx();
        int i = 0;
        while (i < columns) {
            block5: {
                boolean bl;
                block4: {
                    int n;
                    boolean[] blArray;
                    block3: {
                        if (i != decisionIndex) break block3;
                        blArray = colMask;
                        n = i;
                        bl = true;
                        break block4;
                    }
                    if (!ranking.contains(container.attributes[i].name)) break block5;
                    blArray = colMask;
                    n = i;
                    bl = !inverseFiltering;
                }
                blArray[n] = bl;
            }
            ++i;
        }
        System.out.println("Filtered Attributes: \n" + var2_3.toString());
        return colMask;
    }

    /*
     * WARNING - void declaration
     */
    public final String toString() {
        void var1_1;
        StringBuffer tmp = new StringBuffer();
        int size = this.attrMap.size();
        StringBuffer line = new StringBuffer();
        int iSize = this.measures.size();
        line.append("attribute,");
        int i = 0;
        while (i < iSize) {
            line.append(this.measures.get((int)i).name);
            if (i < iSize - 1) {
                line.append(',');
            }
            ++i;
        }
        tmp.append(line).append('\n');
        i = 0;
        while (i < size) {
            void var2_3;
            line = new StringBuffer();
            line.append(this.attrMap.getItem(i)).append(',');
            int j = 0;
            while (j < iSize) {
                line.append(this.importances[i][j]);
                if (j < iSize - 1) {
                    line.append(',');
                }
                ++j;
            }
            tmp.append((StringBuffer)var2_3).append('\n');
            ++i;
        }
        return var1_1.toString();
    }

    /*
     * WARNING - void declaration
     */
    public final boolean load(String inFileName) {
        int i;
        BufferedReader fileReader;
        String fileName;
        String extension = "csv";
        Object object = new File(inFileName);
        if (!((File)object).exists()) {
            return false;
        }
        object = DiscFunctions.getFileExtension(inFileName);
        if (!((String)object).equalsIgnoreCase(extension)) {
            fileName = String.valueOf(fileName) + "." + extension;
        }
        try {
            fileReader = new BufferedReader(new FileReader(fileName));
        }
        catch (IOException iOException) {
            System.err.println("Error opening file. File: " + fileName);
            return false;
        }
        String line = null;
        int lineCount = -1;
        StringList lines = new StringList();
        do {
            try {
                line = fileReader.readLine();
                if (line == null) break;
                if (line.trim().length() == 0) continue;
                ++lineCount;
            }
            catch (Exception e) {
                System.out.println("Error reading input file.");
                e.printStackTrace();
            }
            if (lineCount == 0) {
                String[] list = DiscFunctions.tokenizeString(line, new char[]{','}, false);
                i = 1;
                while (i < list.length) {
                    NodesMeasure measure = new NodesMeasure(null);
                    new NodesMeasure(null).name = list[i];
                    this.measures.add(measure);
                    ++i;
                }
            } else {
                lines.add(line);
            }
        } while (line != null);
        this.mainMeasureIdx = this.measures.size() - 1;
        int size = lines.size();
        this.importances = new float[size][this.measures.size()];
        i = 0;
        while (i < size) {
            String[] list = DiscFunctions.tokenizeString(lines.get(i), new char[]{','}, false);
            String attrName = list[0];
            int attributeIndex = this.attrMap.addItem(attrName);
            int listSize = list.length;
            int j = 1;
            while (j < listSize) {
                this.importances[attributeIndex][j - 1] = Float.parseFloat(list[j]);
                ++j;
            }
            ++i;
        }
        this.getMinMaxImportances(this.mainMeasureIdx);
        try {
            void var2_2;
            var2_2.close();
        }
        catch (IOException e) {
            void var1_1;
            System.err.println("Error closing file. File: " + (String)var1_1);
            e.printStackTrace();
        }
        return true;
    }
}

