/*
 * Decompiled with CFR 0.152.
 */
package dmLab.utils.cmatrix;

public class AccuracyMeasure {
    public static int ACC = 1;
    public static int WACC = 2;

    public static double calcWAcc(double[][] confusionMatrix) {
        int rows = 0;
        double wAcc = 0.0;
        int i = 0;
        while (i < confusionMatrix[0].length) {
            int rowSum = 0;
            int j = 0;
            while (j < confusionMatrix[0].length) {
                rowSum = (int)((double)rowSum + confusionMatrix[i][j]);
                ++j;
            }
            if (rowSum != 0) {
                wAcc += confusionMatrix[i][i] / (double)rowSum;
                ++rows;
            }
            ++i;
        }
        return wAcc /= (double)rows;
    }

    public static double calcAcc(double[][] confusionMatrix) {
        int sum = 0;
        int trueDecision = 0;
        int i = 0;
        while (i < confusionMatrix[0].length) {
            int j = 0;
            while (j < confusionMatrix.length) {
                sum = (int)((double)sum + confusionMatrix[i][j]);
                if (i == j) {
                    trueDecision = (int)((double)trueDecision + confusionMatrix[i][j]);
                }
                ++j;
            }
            ++i;
        }
        return (double)trueDecision / (double)sum;
    }

    public static double calcTPRate(double[][] confusionMatrix, int valueIndex) {
        int rowSum = 0;
        int j = 0;
        while (j < confusionMatrix[0].length) {
            rowSum = (int)((double)rowSum + confusionMatrix[valueIndex][j]);
            ++j;
        }
        return confusionMatrix[valueIndex][valueIndex] / (double)rowSum;
    }

    public static double calcFPRate(double[][] confusionMatrix, int valueIndex) {
        int rowSum = 0;
        int FP = 0;
        int i = 0;
        while (i < confusionMatrix[0].length) {
            if (i != valueIndex) {
                FP = (int)((double)FP + confusionMatrix[i][valueIndex]);
                int j = 0;
                while (j < confusionMatrix.length) {
                    rowSum = (int)((double)rowSum + confusionMatrix[i][j]);
                    ++j;
                }
            }
            ++i;
        }
        return (double)FP / (double)rowSum;
    }

    public static int errors(double[][] confusionMatrix) {
        int errors = 0;
        int i = 0;
        while (i < confusionMatrix[0].length) {
            int j = 0;
            while (j < confusionMatrix.length) {
                if (i != j) {
                    errors = (int)((double)errors + confusionMatrix[i][j]);
                }
                ++j;
            }
            ++i;
        }
        return errors;
    }
}

