% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CLT_new.R
\name{CLT}
\alias{CLT}
\title{The function explores numerical properties of statistical estimators operating on random processes.}
\usage{
CLT(Nmc, s, m, M, alpha, H, sigma, fr, Inference, ...)
}
\arguments{
\item{Nmc}{Number of Monte Carlo repetitions}

\item{s}{sequence of path lengths}

\item{m}{discretization. A number of points between two nearby motion points}

\item{M}{truncation parameter. A number of points at which the integral representing the definition of lfsm is calculated. So, after M points back we consider the rest of the integral to be 0.}

\item{alpha}{self-similarity parameter of alpha stable random motion.}

\item{H}{Hurst parameter}

\item{sigma}{Scale parameter of lfsm}

\item{fr}{frequency. Either "H" or "L"}

\item{Inference}{statistical function to apply to sample paths}

\item{...}{parameters to pass to Inference}
}
\description{
The function performs Monte-Carlo experiments to compute parameters according to procedure Inference.
For each element of s it generates Nmc lfsm sample paths with N=s[i], performs the statistical
inference on each, and then returns their different statistics.
}
\examples{
#### Set of global parameters ####
m<-25; M<-60
p<-.4; p_prime<-.2; k<-2
t1<-1; t2<-2
NmonteC<-5e1
S<-c(1e2,3e2)
alpha<-1.8; H<-0.8; sigma<-0.3
theor_3_1_H_clt<-CLT(s=S,fr='H',Nmc=NmonteC,
                     m=m,M=M,alpha=alpha,H=H,
                     sigma=sigma,ContinEstim,
                     t1=t1,t2=t2,p=p,k=k)
l_plot<-Plot_dens(par_vec=c('sigma','alpha','H'),
                  CLT_data=theor_3_1_H_clt, Nnorm=1e7)
}
