% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lc.R
\name{lc_heatmap}
\alias{lc_heatmap}
\title{Create a heatmap}
\usage{
lc_heatmap(data = list(), place = NULL, ..., id = NULL,
  pacerStep = 50)
}
\arguments{
\item{data}{Name value pairs of properties, passed through the \code{\link{dat}} function. These
properties will be reevaluated on each \code{\link{updateCharts}} call.}

\item{place}{An ID of a container, where to place the chart. Will be ignored if the chart already
exists. If not defined, the chart will be placed directly in the body of the opened page.}

\item{...}{Name value pairs of properties that can be evaluated only once and then will remain
constant. These properties can still be changed later using the \code{\link{setProperties}} function}

\item{id}{An ID for the chart. All charts must have unique IDs. If a chart with the same ID already
exists, a new layer will be added to it. If you want to replace one chart with another, use \code{\link{removeChart}}
first. If not defined, the ID will be set to \code{ChartN}, where \code{N - 1} is the number of currently existing charts.}

\item{pacerStep}{Time in ms between two consecutive calls of an \code{onmouseover} event. Prevents overqueuing in case
of cumbersome computations. May be important when the chart works in canvas mode.}
}
\description{
\code{lc_heatmap} creates a new heatmaps. Unlike charts with axes, heatmaps do not have
any layers.
}
\section{Available properties}{

You can read more about different properties
\href{https://anders-biostat.github.io/linked-charts/rlc/tutorials/props.html}{here}.

\itemize{
\item \code{value} - matrix of values.
\item \code{rowLabel, colLabel} - vector of labels for all rows or columns.
\item \code{showDendogramRow, showDendogramCol} - whether to show dendograms when rows or columns are
clustered. Even if these properties are set to \code{FALSE}, rows and columns can still be clustered.
\item \code{clusterRows, clusterCols} - whether rows or columns should be clustered. If these
properties are set to \code{FALSE}, rows and columns can still be clustered later using the instrument
panel.
\item \code{mode} - one of \code{"default", "svg", "canvas"}. Defines, whether to display heatmap as
an SVG or Canvas object. \code{"default"} mode switches between the two, turning heatmap into Canvas
image, when there are too many cell, and into SVG object otherwise.
\item \code{heatmapRow, heatmapCol} - default order of rows and columns of the heatmap.
\item \code{showValue} - if \code{TRUE}, than in the values will be shown as text in each cell.}

Style settings
\itemize{
\item \code{rowTitle, colTilte} - titles of rows and columns.
\item \code{palette} - vector of colours to construct the colour scale.
\item \code{colourDomain} - domain of the colour scale. All values outside it will
be clamped to its edges.}

Interactivity settings
\itemize{
\item \code{on_click} - function, to be called, when one of the cells is clicked. Gets row and column indices
of the clicked cell as its arguments.
\item \code{on_mouseover} - function, to be called, when mouse hovers over one of the cells.
Gets row and column indices of the clicked cell as its arguments.
\item \code{on_mouseout} - function, to be called, when mouse moves out of one of the cells.
\item \code{on_marked} - function, to be called, when any of the cells are selected (marked)
or deselected. Use \code{\link{getMarked}} function to get the IDs of the currently marked cells.}

Global chart settings
\itemize{
\item \code{width} - width of the chart in pixels.
\item \code{heigth} - height of the chart in pixels.
\item \code{plotWidth} - width of the plotting area in pixels.
\item \code{plotHeight} - height of the plotting area in pixels.
\item \code{paddings} - paddings size in pixels. Must be a list with all the following fields:
\code{"top", "bottom", "left", "right"}.
\item \code{title} - title of the chart.
\item \code{titleX, titleY} - coordinates of the chart title.
\item \code{titleSize} - font-size of the chart title.
\item \code{showLegend} - whether or not to show the legend.
\item \code{showPanel} - whether of not to show the tools panel.
\item \code{transitionDuration} - duration of the transitions between any two states of the chart. If 0,
no animated transition is shown. It can be useful to turn the transition off, when lots of frequent
changes happen to the chart.}
}

\examples{
\donttest{
library(RColorBrewer)
#create a test matrix
test <- cbind(sapply(1:10, function(i) c(rnorm(10, mean = 1, sd = 3), 
                                         rnorm(6, mean = 5, sd = 2), 
                                         runif(14, 0, 8))),
              sapply(1:10, function(i) c(rnorm(10, mean = 3, sd = 2), 
                                         rnorm(6, mean = 1, sd = 2), 
                                         runif(14, 0, 8))))
test[test < 0] <- 0
rownames(test) <- paste0("Gene", 1:30)
colnames(test) <- paste0("Sample", 1:20)

lc_heatmap(dat(value = test))

# when you want to cluster rows or columns, it can be
# a good idea to make bottom and right paddings larger to
# fit labels
lc_heatmap(dat(value = test),
           clusterRows = TRUE,
           clusterCols = TRUE,
           paddings = list(top = 50, left = 30, bottom = 75, right = 75))

lc_heatmap(dat(value = cor(test), 
               colourDomain = c(-1, 1),
               palette = brewer.pal(11, "RdYlBu")))}
}
