% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ppi_calcs.R
\name{models_visited}
\alias{models_visited}
\title{Count the number of times a model is visited}
\usage{
models_visited(thetas)
}
\arguments{
\item{thetas}{Vector of model indicies from the PDMP trajectory or samples from an MCMC sampler}
}
\value{
Returns a Matrix with rows corresponding to models and a final column corresponding to the number of times the model is visited
}
\description{
Count the number of times a model is visited
}
\examples{
generate.logistic.data <- function(beta, n.obs, Sig) {
p <- length(beta)
dataX <- MASS::mvrnorm(n=n.obs,mu=rep(0,p),Sigma=Sig)
vals <- dataX \%*\% as.vector(beta)
generateY <- function(p) { rbinom(1, 1, p)}
dataY <- sapply(1/(1 + exp(-vals)), generateY)
return(list(dataX = dataX, dataY = dataY))
}

n <- 15
p <- 25
beta <- c(1, rep(0, p-1))
Siginv <- diag(1,p,p)
Siginv[1,2] <- Siginv[2,1] <- 0.9
set.seed(1)
data <- generate.logistic.data(beta, n, solve(Siginv))
ppi <- 2/p

zigzag_fit <- zigzag_logit(maxTime = 1, dataX = data$dataX, datay = data$dataY,
                           prior_sigma2 = 10,theta0 = rep(0, p), x0 = rep(0, p),
                           rj_val = 0.6, ppi = ppi)
models_visited(zigzag_fit$theta)

}
