% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/d.R
\name{d}
\alias{d}
\title{Estimate the incremental explained risk variation in a case-control study}
\usage{
d(label, M, factors, data)
}
\arguments{
\item{label}{the name of the subtype variable in the data. This should be a
numeric variable with values 0 through M, where 0 indicates control subjects.
Must be supplied in quotes, e.g. \code{label = "subtype"}.
quotes.}

\item{M}{is the number of subtypes. For M>=2.}

\item{factors}{a list of the names of the binary or continuous risk factors.
For binary risk factors the lowest level will be used as the reference level.
e.g. \code{factors = list("age", "sex", "race")}.}

\item{data}{the name of the dataframe that contains the relevant variables.}
}
\description{
\code{d} estimates the incremental explained risk variation
across a set of pre-specified disease subtypes in a case-control study.
This function takes the name of the disease subtype variable, the number
of disease subtypes, a list of risk factors, and a wide dataset,
and does the needed
transformation on the dataset to get the correct format. Then the polytomous
logistic regression model is fit using \code{\link[mlogit]{mlogit}},
and D is calculated based on the resulting risk predictions.
}
\examples{

d(
  label = "subtype",
  M = 4,
  factors = list("x1", "x2", "x3"),
  data = subtype_data
)
}
\references{
Begg, C. B., Zabor, E. C., Bernstein, J. L., Bernstein, L., Press, M. F., &
Seshan, V. E. (2013). A conceptual and methodological framework for
investigating etiologic heterogeneity. Stat Med, 32(29), 5039-5052.
doi: 10.1002/sim.5902
}
