% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils-file.R
\name{data_dir}
\alias{data_dir}
\alias{src_data_dir}
\alias{auto_attach_srcs}
\alias{config_paths}
\alias{get_config}
\alias{set_config}
\title{File system utilities}
\usage{
data_dir(subdir = NULL, create = TRUE)

src_data_dir(srcs)

auto_attach_srcs()

config_paths()

get_config(name, cfg_dirs = config_paths(), combine_fun = c, ...)

set_config(x, name, dir = file.path("inst", "extdata", "config"), ...)
}
\arguments{
\item{subdir}{A string specifying a directory that will be made sure to
exist below the data directory.}

\item{create}{Logical flag indicating whether to create the specified
directory}

\item{srcs}{Character vector of data source names, an object for which an
\code{src_name()} method is defined or an arbitrary-length list thereof.}

\item{name}{File name of the configuration file (\code{.json} will be appended)}

\item{cfg_dirs}{Character vector of directories searched for config files}

\item{combine_fun}{If multiple files are found, a function for combining
returned lists}

\item{...}{Passed to \code{\link[jsonlite:read_json]{jsonlite::read_json()}} or \code{\link[jsonlite:read_json]{jsonlite::write_json()}}}

\item{x}{Object to be written}

\item{dir}{Directory to write the file to (created if non-existent)}
}
\value{
Functions \code{data_dir()}, \code{src_data_dir()} and \code{config_paths()} return
file paths as character vectors, \code{auto_attach_srcs()} returns a character
vector of data source names, \code{src_data_avail()} returns a \code{data.frame}
describing availability of data sources and \code{is_data_avail()} a named
logical vector. Configuration utilities \code{get_config()} and \code{set_config()}
read and write list objects to/from JSON format.
}
\description{
Determine the location where to place data meant to persist between
individual sessions.
}
\details{
For data, the default location depends on the operating system as\tabular{ll}{
   \strong{Platform} \tab \strong{Location} \cr
   Linux \tab \verb{~/.local/share/ricu} \cr
   macOS \tab \verb{~/Library/Application Support/ricu} \cr
   Windows \tab \verb{\%LOCALAPPDATA\%/ricu} \cr
}


If the default storage directory does not exists, it will only be created
upon user consent (requiring an interactive session).

The environment variable \code{RICU_DATA_PATH} can be used to overwrite the
default location. If desired, this variable can be set in an R startup file
to make it apply to all R sessions. For example, it could be set within:
\itemize{
\item A project-local \code{.Renviron};
\item The user-level \code{.Renviron};
\item A file at \verb{$(R RHOME)/etc/Renviron.site}.
}

Any directory specified as environment variable will recursively be created.

Data source directories typically are sub-directories to \code{data_dir()} named
the same as the respective dataset. For demo datasets corresponding to
\code{mimic} and \code{eicu}, file location however deviates from this scheme. The
function \code{src_data_dir()} is used to determine the expected data location
of a given dataset.

Configuration files used both for data source configuration, as well as for
dictionary definitions potentially involve multiple files that are read and
merged. For that reason, \code{get_config()} will iterate over directories
passed as \code{cfg_dirs} and look for the specified file (with suffix \code{.json}
appended and might be missing in some of the queried directories). All
found files are read by \code{\link[jsonlite:read_json]{jsonlite::read_json()}} and the resulting lists are
combined by reduction with the binary function passed as \code{combine_fun}.

With default arguments, \code{get_config()} will simply concatenate lists
corresponding to files found in the default config locations as returned by
\code{config_paths()}: first the directory specified by the environment variable
\code{RICU_CONFIG_PATH} (if set), followed by the directory at

\if{html}{\out{<div class="sourceCode">}}\preformatted{system.file("extdata", "config", package = "ricu")
}\if{html}{\out{</div>}}

Further arguments are passed to \code{\link[jsonlite:read_json]{jsonlite::read_json()}}, which is called
with slightly modified defaults: \code{simplifyVector = TRUE},
\code{simplifyDataFrame = FALSE} and \code{simplifyMatrix = FALSE}.

The utility function \code{set_config()} writes the list passed as \code{x} to file
\code{dir/name.json}, using \code{\link[jsonlite:read_json]{jsonlite::write_json()}} also with slightly modified
defaults (which can be overridden by passing arguments as \code{...}): \code{null = "null"}, \code{auto_unbox = TRUE} and \code{pretty = TRUE}.

Whenever the package namespace is attached, a summary of dataset
availability is printed using the utility functions \code{auto_attach_srcs()}
and \code{src_data_avail()}. While the former simply returns a character vector
of data sources that are configures for automatically being set up on
package loading, the latter returns a summary of the number of available
tables per dataset.m Finally, \code{is_data_avail()} returns a named logical
vector indicating which data sources have all required data available.
}
\examples{
Sys.setenv(RICU_DATA_PATH = tempdir())
identical(data_dir(), tempdir())

dir.exists(file.path(tempdir(), "some_subdir"))
some_subdir <- data_dir("some_subdir")
dir.exists(some_subdir)

cfg <- get_config("concept-dict")

identical(
  cfg,
  get_config("concept-dict",
             system.file("extdata", "config", package = "ricu"))
)

}
