% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/flsgen_create_landscape_targets.R
\name{flsgen_create_landscape_targets}
\alias{flsgen_create_landscape_targets}
\title{Creates a set of targets for a landscape}
\usage{
flsgen_create_landscape_targets(
  nb_rows,
  nb_cols,
  classes,
  mask_raster = NULL,
  NON_FOCAL_PLAND = NULL
)
}
\arguments{
\item{nb_rows}{Number of rows}

\item{nb_cols}{Number of columns}

\item{classes}{list of class targets}

\item{mask_raster}{mask raster (path or terra::rast object)}

\item{NON_FOCAL_PLAND}{PLAND (proportion of landscape) target on the non-focal land-use class}
}
\value{
A landscape targets object which can be converted to JSON for flsgen
}
\description{
Creates a set of targets for a landscape, which can be
converted into JSON for flsgen.
}
\details{
The class targets must be created prior to the call to this function

Either nb_rows and nb_cols, or mask_raster must be specified. The dimensions
of the landscape are deduced from the mask raster if it is used.
}
\examples{
  \dontrun{
    cls_1 <- flsgen_create_class_targets("class 1", NP=c(1, 10), AREA=c(0, 1000))
    cls_2 <- flsgen_create_class_targets("class 2", NP=c(1, 10), AREA=c(0, 1000))
    ls_targets <- flsgen_create_landscape_targets(200, 200, list(cls_1, cls_2))
  }
}
