/*
 * Decompiled with CFR 0.152.
 */
package org.flsgen.grid.regular.square;

import java.util.HashSet;
import java.util.Set;
import java.util.stream.IntStream;
import org.flsgen.grid.regular.square.RegularSquareGrid;

public class PartialRegularSquareGrid
extends RegularSquareGrid {
    protected Set<Integer> discardSet = new HashSet<Integer>();
    protected int[] partialToComplete;
    protected int[] completeToPartial;

    public PartialRegularSquareGrid(int nbRows, int nbCols, int[] toDiscard) {
        super(nbRows, nbCols);
        IntStream.of(toDiscard).forEach(i -> this.discardSet.add(i));
        this.partialToComplete = new int[this.getNbCells()];
        this.completeToPartial = new int[nbRows * nbCols];
        int j = 0;
        for (int i2 = 0; i2 < nbRows * nbCols; ++i2) {
            if (!this.discardSet.contains(i2)) {
                this.partialToComplete[j] = i2;
                this.completeToPartial[i2] = j++;
                continue;
            }
            this.completeToPartial[i2] = -1;
        }
    }

    @Override
    public int getNbCells() {
        return this.nbRows * this.nbCols - this.discardSet.size();
    }

    @Override
    public int getIndexFromCoordinates(int row, int col) {
        assert (row >= 0);
        assert (row < this.nbRows);
        assert (col >= 0);
        assert (col < this.nbCols);
        return this.getPartialIndex(this.getNbCols() * row + col);
    }

    @Override
    public int[] getCoordinatesFromIndex(int index) {
        int completeIndex = this.getCompleteIndex(index);
        int row = Math.floorDiv(completeIndex, this.getNbCols());
        int col = completeIndex % this.getNbCols();
        return new int[]{row, col};
    }

    public int getCompleteIndex(int partialIdx) {
        return this.partialToComplete[partialIdx];
    }

    public int getPartialIndex(int completeIdx) {
        return this.completeToPartial[completeIdx];
    }

    public Set<Integer> getDiscardSet() {
        return this.discardSet;
    }

    @Override
    public int getNbRows() {
        return this.nbRows;
    }

    @Override
    public int getNbCols() {
        return this.nbCols;
    }

    @Override
    public double[][] getCartesianCoordinates() {
        double[][] coords = new double[this.getNbCells()][];
        for (int i = 0; i < this.getNbCells(); ++i) {
            int[] coord = this.getCoordinatesFromIndex(i);
            coords[i] = new double[]{coord[1], coord[0]};
        }
        return coords;
    }
}

