/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.solver.variables.impl;

import java.util.Arrays;
import java.util.Spliterator;
import java.util.function.Consumer;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.chocosolver.memory.IEnvironment;
import org.chocosolver.memory.IStateInt;
import org.chocosolver.solver.Cause;
import org.chocosolver.solver.ICause;
import org.chocosolver.solver.Model;
import org.chocosolver.solver.constraints.Propagator;
import org.chocosolver.solver.exception.ContradictionException;
import org.chocosolver.solver.propagation.PropagationEngine;
import org.chocosolver.solver.variables.BoolVar;
import org.chocosolver.solver.variables.IVariableMonitor;
import org.chocosolver.solver.variables.IntVar;
import org.chocosolver.solver.variables.RealVar;
import org.chocosolver.solver.variables.SetVar;
import org.chocosolver.solver.variables.Variable;
import org.chocosolver.solver.variables.events.IEventType;
import org.chocosolver.solver.variables.view.IView;
import org.chocosolver.util.iterators.EvtScheduler;

public abstract class AbstractVariable
implements Variable {
    static final String MSG_REMOVE = "remove last value";
    protected static final String MSG_EMPTY = "empty domain";
    protected static final String MSG_INST = "the variable is already instantiated to another value";
    static final String MSG_UNKNOWN = "unknown value";
    static final String MSG_UPP = "the new upper bound is lesser than the current lower bound";
    static final String MSG_LOW = "the new lower bound is greater than the current upper bound";
    static final String MSG_BOUND = "new bounds are incorrect";
    private final int ID;
    protected final Model model;
    protected final String name;
    final BipartiteList[] propagators;
    private int nbPropagators;
    private IView<?>[] views;
    private int[] idxInViews;
    private int vIdx;
    protected IVariableMonitor[] monitors;
    protected int mIdx;
    private final EvtScheduler<?> scheduler;
    private int instWI;
    private int mask;
    private ICause cause;
    public boolean scheduled;

    protected AbstractVariable(String name, Model model) {
        this.name = name;
        this.model = model;
        this.views = new IView[2];
        this.idxInViews = new int[2];
        this.monitors = new IVariableMonitor[2];
        this.scheduler = this.createScheduler();
        int dsize = this.scheduler.select(0);
        this.propagators = new BipartiteList[dsize + 1];
        for (int i = 0; i < dsize + 1; ++i) {
            this.propagators[i] = new BipartiteList(model.getEnvironment());
        }
        this.nbPropagators = 0;
        this.ID = this.model.nextId();
        this.model.associates(this);
        this.instWI = 0;
        this.scheduled = false;
    }

    protected abstract EvtScheduler<?> createScheduler();

    @Override
    public boolean isScheduled() {
        return this.scheduled;
    }

    @Override
    public void schedule() {
        this.scheduled = true;
    }

    @Override
    public void schedulePropagators(PropagationEngine engine) {
        if (this.mask > 0) {
            EvtScheduler<?> si = this.getEvtScheduler();
            si.init(this.mask);
            while (si.hasNext()) {
                int j = si.next();
                for (int i = si.next(); i < j; ++i) {
                    this.propagators[i].schedule(this.cause, engine, this.mask);
                }
            }
        }
        this.clearEvents();
    }

    @Override
    public void unschedule() {
        this.scheduled = false;
    }

    @Override
    public final int getId() {
        return this.ID;
    }

    @Override
    public final void link(Propagator<?> propagator, int idxInProp) {
        int i = this.scheduler.select(propagator.getPropagationConditions(idxInProp));
        ++this.nbPropagators;
        propagator.setVIndices(idxInProp, this.propagators[i].add(propagator, idxInProp));
    }

    @Override
    public final void unlink(Propagator<?> propagator, int idxInProp) {
        int i = this.scheduler.select(propagator.getPropagationConditions(idxInProp));
        --this.nbPropagators;
        this.propagators[i].remove(propagator, idxInProp, this);
    }

    @Override
    public void swapOnPassivate(Propagator<?> propagator, int idxInProp) {
        int i = this.scheduler.select(propagator.getPropagationConditions(idxInProp));
        this.propagators[i].swap(propagator, idxInProp, this);
    }

    @Override
    @Deprecated
    public int swapOnActivate(Propagator<?> propagator, int idxInProp) {
        throw new UnsupportedOperationException("Cannot swap on activation");
    }

    @Override
    public final Propagator<?>[] getPropagators() {
        throw new UnsupportedOperationException("The method is deprecated");
    }

    @Override
    public final Propagator<?> getPropagator(int idx) {
        throw new UnsupportedOperationException("The method is deprecated");
    }

    @Override
    public Stream<Propagator<?>> streamPropagators() {
        Spliterator it = new Spliterator<Propagator<?>>(){
            int c = 0;
            int i;
            {
                this.i = AbstractVariable.this.propagators[this.c].first;
            }

            @Override
            public boolean tryAdvance(Consumer<? super Propagator<?>> action) {
                while (true) {
                    if (this.i < AbstractVariable.this.propagators[this.c].last) {
                        action.accept(AbstractVariable.this.propagators[this.c].propagators[this.i++]);
                        return true;
                    }
                    ++this.c;
                    if (this.c >= AbstractVariable.this.propagators.length) break;
                    this.i = AbstractVariable.this.propagators[this.c].first;
                }
                return false;
            }

            @Override
            public Spliterator<Propagator<?>> trySplit() {
                return null;
            }

            @Override
            public long estimateSize() {
                return AbstractVariable.this.nbPropagators;
            }

            @Override
            public int characteristics() {
                return 4369;
            }
        };
        return StreamSupport.stream(it, false);
    }

    @Override
    public final int getNbProps() {
        return this.nbPropagators;
    }

    @Override
    public final int[] getPIndices() {
        throw new UnsupportedOperationException("The method is deprecated");
    }

    @Override
    public final void setPIndice(int pos, int val) {
        throw new UnsupportedOperationException("setPIndice to be implemented");
    }

    @Override
    @Deprecated
    public final int getDindex(int i) {
        throw new UnsupportedOperationException("The method is deprecated");
    }

    @Override
    public final int getIndexInPropagator(int pidx) {
        throw new UnsupportedOperationException("setPIndice to be implemented");
    }

    @Override
    public int instantiationWorldIndex() {
        return this.isInstantiated() ? this.instWI : Integer.MAX_VALUE;
    }

    @Override
    public void recordWorldIndex() {
        this.instWI = this.model.getEnvironment().getWorldIndex();
    }

    @Override
    public final String getName() {
        return this.name;
    }

    @Override
    public void notifyPropagators(IEventType event, ICause cause) throws ContradictionException {
        assert (cause != null);
        if (this.isInstantiated()) {
            this.recordWorldIndex();
        }
        this.model.getSolver().getEngine().onVariableUpdate(this, event, cause);
        this.notifyMonitors(event);
        this.notifyViews(event, cause);
    }

    @Override
    public void notifyMonitors(IEventType event) throws ContradictionException {
        for (int i = this.mIdx - 1; i >= 0; --i) {
            this.monitors[i].onUpdate(this, event);
        }
    }

    @Override
    public void notifyViews(IEventType event, ICause cause) throws ContradictionException {
        assert (cause != null);
        if (cause == Cause.Null) {
            for (int i = this.vIdx - 1; i >= 0; --i) {
                this.views[i].notify(event, this.idxInViews[i]);
            }
        } else {
            for (int i = this.vIdx - 1; i >= 0; --i) {
                if (this.views[i] == cause) continue;
                this.views[i].notify(event, this.idxInViews[i]);
            }
        }
    }

    @Override
    public void addMonitor(IVariableMonitor<?> monitor) {
        if (this.model.getSettings().checkDeclaredMonitors()) {
            for (int i = 0; i < this.mIdx; ++i) {
                if (this.monitors[i] != monitor) continue;
                return;
            }
        }
        if (this.mIdx == this.monitors.length) {
            IVariableMonitor[] tmp = this.monitors;
            this.monitors = new IVariableMonitor[tmp.length * 3 / 2 + 1];
            System.arraycopy(tmp, 0, this.monitors, 0, this.mIdx);
        }
        this.monitors[this.mIdx++] = monitor;
    }

    @Override
    public void removeMonitor(IVariableMonitor<?> monitor) {
        int i;
        for (i = this.mIdx - 1; i >= 0 && this.monitors[i] != monitor; --i) {
        }
        if (i < this.mIdx - 1) {
            System.arraycopy(this.monitors, i + 1, this.monitors, i, this.mIdx - (i + 1));
        }
        this.monitors[--this.mIdx] = null;
    }

    @Override
    public void subscribeView(IView<?> view, int idx) {
        if (this.vIdx == this.views.length) {
            IView<?>[] tmp = this.views;
            int[] tmpIdx = this.idxInViews;
            this.views = new IView[tmp.length * 3 / 2 + 1];
            this.idxInViews = new int[tmp.length * 3 / 2 + 1];
            System.arraycopy(tmp, 0, this.views, 0, this.vIdx);
            System.arraycopy(tmpIdx, 0, this.idxInViews, 0, this.vIdx);
        }
        this.views[this.vIdx] = view;
        this.idxInViews[this.vIdx] = idx;
        ++this.vIdx;
    }

    @Override
    public final void contradiction(ICause cause, String message) throws ContradictionException {
        assert (cause != null);
        this.model.getSolver().throwsException(cause, this, message);
    }

    @Override
    public final Model getModel() {
        return this.model;
    }

    @Override
    public int getNbViews() {
        return this.vIdx;
    }

    @Override
    public IView<?> getView(int idx) {
        return this.views[idx];
    }

    @Override
    public int compareTo(Variable o) {
        return this.getId() - o.getId();
    }

    public String toString() {
        return this.getName();
    }

    public final boolean isBool() {
        return (this.getTypeAndKind() & 0x3F8) == 24;
    }

    @Override
    public final boolean isAConstant() {
        return (this.getTypeAndKind() & 7) == 2;
    }

    @Override
    public final EvtScheduler<?> getEvtScheduler() {
        return this.scheduler;
    }

    @Override
    public IntVar asIntVar() {
        return (IntVar)((Object)this);
    }

    @Override
    public BoolVar asBoolVar() {
        return (BoolVar)((Object)this);
    }

    @Override
    public RealVar asRealVar() {
        return (RealVar)((Object)this);
    }

    @Override
    public SetVar asSetVar() {
        return (SetVar)((Object)this);
    }

    @Override
    public void storeEvents(int m, ICause cause) {
        assert (cause != null) : "an event's cause is not supposed to be null";
        if (this.cause == null) {
            this.cause = cause;
        } else if (this.cause != cause) {
            this.cause = Cause.Null;
        }
        this.mask |= m;
    }

    @Override
    public void clearEvents() {
        this.cause = null;
        this.mask = 0;
        this.unschedule();
    }

    @Override
    public int getMask() {
        return this.mask;
    }

    @Override
    public ICause getCause() {
        return this.cause;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof AbstractVariable)) {
            return false;
        }
        AbstractVariable that = (AbstractVariable)o;
        return this.ID == that.ID;
    }

    public int hashCode() {
        return this.ID;
    }

    static class BipartiteList {
        private int capacity;
        int first;
        int last;
        final IStateInt splitter;
        Propagator<?>[] propagators;
        int[] pindices;

        public BipartiteList(IEnvironment environment) {
            this.splitter = environment.makeInt(0);
            this.last = 0;
            this.first = 0;
            this.capacity = 10;
            this.propagators = new Propagator[this.capacity];
            this.pindices = new int[this.capacity];
        }

        public int add(Propagator<?> propagator, int idxInVar) {
            if (this.first > 0 && this.splitter.get() == 0) {
                this.shiftTail();
            }
            if (this.last == this.capacity - 1) {
                this.capacity += this.capacity >> 1;
                this.propagators = Arrays.copyOf(this.propagators, this.capacity);
                this.pindices = Arrays.copyOf(this.pindices, this.capacity);
            }
            this.propagators[this.last] = propagator;
            this.pindices[this.last++] = idxInVar;
            return this.last - 1;
        }

        public void remove(Propagator<?> propagator, int idxInProp, AbstractVariable var) {
            int p = propagator.getVIndice(idxInProp);
            assert (p > -1);
            assert (this.propagators[p] == propagator) : "Try to unlink from " + var.getName() + ":\n" + propagator + "but found:\n" + this.propagators[p];
            assert (this.propagators[p].getVar(idxInProp) == var);
            if (p < this.splitter.get()) {
                propagator.setVIndices(idxInProp, -1);
                this.propagators[p] = this.propagators[this.first];
                this.pindices[p] = this.pindices[this.first];
                this.propagators[p].setVIndices(this.pindices[p], p);
                this.propagators[this.first] = null;
                this.pindices[this.first] = 0;
                ++this.first;
            } else {
                --this.last;
                if (p < this.last) {
                    this.propagators[p] = this.propagators[this.last];
                    this.pindices[p] = this.pindices[this.last];
                    this.propagators[p].setVIndices(this.pindices[p], p);
                }
                this.propagators[this.last] = null;
                this.pindices[this.last] = 0;
                propagator.setVIndices(idxInProp, -1);
            }
        }

        public void swap(Propagator<?> propagator, int idxInProp, AbstractVariable var) {
            int p = propagator.getVIndice(idxInProp);
            assert (p != -1);
            assert (this.propagators[p] == propagator) : "Try to swap from " + var.getName() + ":\n" + propagator + "but found: " + this.propagators[p];
            assert (this.propagators[p].getVar(idxInProp) == var);
            int pos = this.splitter.add(1) - 1;
            if (this.first > 0) {
                if (pos == 0) {
                    this.shiftTail();
                    p = propagator.getVIndice(idxInProp);
                } else {
                    throw new UnsupportedOperationException();
                }
            }
            if (pos < p) {
                this.propagators[p] = this.propagators[pos];
                this.propagators[pos] = propagator;
                int pi = this.pindices[p];
                this.pindices[p] = this.pindices[pos];
                this.pindices[pos] = pi;
                this.propagators[p].setVIndices(this.pindices[p], p);
                this.propagators[pos].setVIndices(this.pindices[pos], pos);
                assert (this.propagators[pos] == propagator);
            }
        }

        public void schedule(ICause cause, PropagationEngine engine, int mask) {
            int s = this.splitter.get();
            if (this.first > 0) {
                if (s == 0) {
                    this.shiftTail();
                } else {
                    throw new UnsupportedOperationException();
                }
            }
            for (int p = s; p < this.last; ++p) {
                Propagator<?> prop = this.propagators[p];
                if (!prop.isActive() || cause == prop) continue;
                engine.schedule(prop, this.pindices[p], mask);
            }
        }

        private void shiftTail() {
            int i;
            for (i = 0; i < this.last - this.first; ++i) {
                this.propagators[i] = this.propagators[i + this.first];
                this.pindices[i] = this.pindices[i + this.first];
                this.propagators[i].setVIndices(this.pindices[i], i);
            }
            for (i = this.last - this.first; i < this.last; ++i) {
                this.propagators[i] = null;
                this.pindices[i] = 0;
            }
            this.last -= this.first;
            this.first = 0;
        }

        Stream<Propagator<?>> stream() {
            final int s = this.splitter.get();
            if (this.first > 0 && s == 0) {
                this.shiftTail();
            }
            Spliterator it = new Spliterator<Propagator<?>>(){
                int i;
                {
                    this.i = s;
                }

                @Override
                public boolean tryAdvance(Consumer<? super Propagator<?>> action) {
                    if (this.i < last) {
                        action.accept(propagators[this.i++]);
                        return true;
                    }
                    return false;
                }

                @Override
                public Spliterator<Propagator<?>> trySplit() {
                    return null;
                }

                @Override
                public long estimateSize() {
                    return last - first;
                }

                @Override
                public int characteristics() {
                    return 4369;
                }
            };
            return StreamSupport.stream(it, false);
        }
    }
}

