% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/install-python.R
\name{install_python}
\alias{install_python}
\title{Install Python}
\usage{
install_python(
  version = "3.12:latest",
  list = FALSE,
  force = FALSE,
  optimized = TRUE
)
}
\arguments{
\item{version}{The version of Python to install.}

\item{list}{Boolean; if set, list the set of available Python versions?}

\item{force}{Boolean; force re-installation even if the requested version of
Python is already installed?}

\item{optimized}{Boolean; if \code{TRUE}, installation will take significantly
longer but should result in a faster Python interpreter. Only applicable on
macOS and Linux.}
}
\description{
Download and install Python, using the
\href{https://github.com/pyenv/pyenv}{pyenv}. and
\href{https://github.com/pyenv-win/pyenv-win}{pyenv-win} projects.
}
\details{
In general, it is recommended that Python virtual environments are created
using the copies of Python installed by \code{\link[=install_python]{install_python()}}. For example:

\if{html}{\out{<div class="sourceCode">}}\preformatted{library(reticulate)
version <- "3.9.12"
install_python(version)
virtualenv_create("my-environment", version = version)
use_virtualenv("my-environment")

# There is also support for a ":latest" suffix to select the latest patch release
install_python("3.9:latest") # install latest patch available at python.org

# select the latest 3.9.* patch installed locally
virtualenv_create("my-environment", version = "3.9:latest")
}\if{html}{\out{</div>}}
}
\note{
On macOS and Linux this will build Python from sources, which may take a few
minutes. Installation will be faster if some build dependencies are
preinstalled. See
\url{https://github.com/pyenv/pyenv/wiki#suggested-build-environment} for example
commands you can run to pre-install system dependencies (requires
administrator privileges).

For example, on macOS you can pre-run:

\if{html}{\out{<div class="sourceCode">}}\preformatted{brew install openssl readline sqlite3 xz zlib tcl-tk@8 libb2
}\if{html}{\out{</div>}}

If \code{optimized = TRUE}, (the default) Python is build with:

\if{html}{\out{<div class="sourceCode">}}\preformatted{PYTHON_CONFIGURE_OPTS="--enable-shared --enable-optimizations --with-lto"
PYTHON_CFLAGS="-march=native -mtune=native"
}\if{html}{\out{</div>}}

If \code{optimized = FALSE}, Python is built with:

\if{html}{\out{<div class="sourceCode">}}\preformatted{PYTHON_CONFIGURE_OPTS=--enable-shared
}\if{html}{\out{</div>}}

On Windows, prebuilt installers from \url{https://www.python.org} are used.
}
