% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/subresultants.R
\name{subresultants}
\alias{subresultants}
\title{Subresultants of two polynomials}
\usage{
subresultants(qspray1, qspray2, var = 1)
}
\arguments{
\item{qspray1, qspray2}{two \code{qspray} polynomials having at most nine
variables}

\item{var}{integer indicating with respect to which variable the
subresultants will be computed (e.g. \code{1} for \code{x} and \code{2}
for \code{y})}
}
\value{
A list of \code{qspray} polynomials.
}
\description{
Subresultants of two polynomials with rational coefficients.
}
\examples{
library(resultant)
x <- qlone(1)
y <- qlone(2)
p <- x^2 * y * (y^2 - 5*x + 6)
q <- x^2 * y * (3*y + 2)
subresultants(p, q, var = 1)
subresultants(p, q, var = 2)
}
