% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/options.R
\name{reproducibleOptions}
\alias{reproducibleOptions}
\title{\code{reproducible} options}
\usage{
reproducibleOptions()
}
\value{
This function returns a list of all the options that the \code{reproducible} package
sets and uses. See below for details of each.
}
\description{
These provide top-level, powerful settings for a comprehensive
reproducible workflow. To see defaults, run \code{reproducibleOptions()}.
See Details below.
}
\details{
Below are options that can be set with \code{options("reproducible.xxx" = newValue)},
where \code{xxx} is one of the values below, and \code{newValue} is a new value to
give the option. Sometimes these options can be placed in the user's \code{.Rprofile}
file so they persist between sessions.

The following options are likely of interest to most users:
\describe{
\item{\code{ask}}{
Default: \code{TRUE}. Used in \code{\link[=clearCache]{clearCache()}} and \code{\link[=keepCache]{keepCache()}}.
}
\item{\code{cachePath}}{
Default: \code{.reproducibleTempCacheDir}. Used in \code{\link[=Cache]{Cache()}} and many others.
The default path for repositories if not passed as an argument.
}
\item{\code{cacheSaveFormat}}{
Default: \code{"rds"}. What save format to use; currently, \code{"qs"} or \code{"rds"}.
}
\item{\code{cacheSpeed}}{
Default \code{"slow"}. One of \code{"slow"} or \code{"fast"} (1 or 2).
\code{"slow"} uses \code{digest::digest} internally, which is transferable across operating
systems, but much slower than \verb{digest::digest(algo = "spooky)}.
So, if all caching is happening on a single machine, \code{"fast"} would be a good setting.
}
\item{\code{conn}}{
Default: \code{NULL}. Sets a specific connection to a database, e.g.,
\code{dbConnect(drv = RSQLite::SQLite())} or \verb{dbConnect(drv = RPostgres::Postgres()}.
For remote database servers, setting one connection may be far faster than using
\code{drv} which must make a new connection every time.
}
\item{\code{destinationPath}}{
Default: \code{NULL}. Used in \code{\link[=prepInputs]{prepInputs()}} and \code{\link[=preProcess]{preProcess()}}.
Can be set globally here.
}
\item{\code{drv}}{
Default: \code{RSQLite::SQLite()}. Sets the default driver for the backend database system.
Only tested with \code{RSQLite::SQLite()} and \code{RPostgres::Postgres()}.
}
\item{\code{futurePlan}}{
Default: \code{FALSE}. On Linux OSes, \code{Cache} and \code{cloudCache} have some
functionality that uses the \code{future} package.
Default is to not use these, as they are experimental.
They may, however, be very effective in speeding up some things, specifically,
uploading cached elements via \code{googledrive} in \code{cloudCache}.
}
\item{\code{gdalwarp}}{
Default: \code{FALSE}. Experimental. During \code{postProcessTo} the standard approach
is to use \code{terra} functions directly, with several strategic uses of \code{sf}. However,
in the special case when \code{from} is a \code{SpatRaster} or \code{Raster}, \code{maskTo} is a
\code{SpatVector} or \code{SFC_POLYGON} and \code{projectTo} is a \code{SpatRaster} or \code{Raster}, setting
this option to \code{TRUE} will use \code{sf::gdal_utils("warp")}. In many test cases,
this is much faster than the \code{terra} sequence. The resulting \code{SpatRaster} is
not identical, but it is very similar.
}
\item{\code{gdalwarpThreads}}{
Default: \code{2}. This will set \verb{-wo NUM_THREADS=} to this number. Default is now \code{2}, meaning
\code{gdalwarp} will use 2 threads with \code{gdalProject}. To turn off threading, set to \code{0}, \code{1} or \code{NA}.
}
\item{\code{inputPaths}}{
Default: \code{NULL}. Used in \code{\link[=prepInputs]{prepInputs()}} and \code{\link[=preProcess]{preProcess()}}.
If set to a path, this will cause these functions to save their downloaded and preprocessed
file to this location, with a hardlink (via \code{file.link}) to the file created in the
\code{destinationPath}.
This can be used so that individual projects that use common data sets can maintain
modularity (by placing downloaded objects in their \code{destinationPath}, but also minimize
re-downloading the same (perhaps large) file over and over for each project.
Because the files are hardlinks, there is no extra space taken up by the apparently
duplicated files.
}
\item{\code{inputPathsRecursive}}{
Default: \code{FALSE}. Used in \code{\link[=prepInputs]{prepInputs()}} and \code{\link[=preProcess]{preProcess()}}.
Should the \code{reproducible.inputPaths} be searched recursively for existence of a file?
}
\item{\code{memoisePersist}}{
Default: \code{FALSE}. Used in \code{\link[=Cache]{Cache()}}.
Should the memoised copy of the Cache objects persist even if \code{reproducible} reloads
e.g., via \code{devtools::load_all}? This is mostly useful for developers of
\code{reproducible}. If \code{TRUE}, a object named \code{paste0(".reproducibleMemoise_", cachePath)}
will be placed in the \code{.GlobalEnv}, i.e., one for each \code{cachePath}.
}
\item{\code{nThreads}}{
Default: \code{1}. The number of threads to use for reading/writing cache files.
}
\item{\code{objSize}}{
Default: \code{TRUE}. Logical. If \code{TRUE}, then object sizes will be included in
the cache database. Simplying calculating object size of large objects can
be time consuming, so setting this to \code{FALSE} will make caching up to 10\%
faster, depending on the objects.
}
\item{\code{overwrite}}{
Default: \code{FALSE}. Used in \code{\link[=prepInputs]{prepInputs()}}, \code{\link[=preProcess]{preProcess()}},
\code{\link[=downloadFile]{downloadFile()}}, and \code{\link[=postProcess]{postProcess()}}.
}
\item{\code{quick}}{
Default: \code{FALSE}. Used in \code{\link[=Cache]{Cache()}}. This will cause \code{Cache} to use
\code{file.size(file)} instead of the \code{digest::digest(file)}.
Less robust to changes, but faster. \emph{NOTE: this will only affect objects on disk}.
}
\item{\code{rasterRead}}{
Used during \code{prepInputs} when reading \code{.tif}, \code{.grd}, and \code{.asc} files.
Default: \code{terra::rast}. Can be \code{raster::raster} for backwards compatibility.
Can be set using environment variable \code{R_REPRODUCIBLE_RASTER_READ}.
}
\item{\code{shapefileRead}}{
Default \code{NULL}. Used during \code{prepInputs} when reading a \code{.shp} file.
If \code{NULL}, it will use \code{sf::st_read} if \code{sf} package is available; otherwise,
it will use \code{raster::shapefile}
}
\item{\code{showSimilar}}{
Default \code{FALSE}. Passed to \code{Cache}.
}
\item{\code{timeout}}{
Default \code{1200}. Used in \code{preProcess} when downloading occurs. If a user has \code{R.utils}
package installed, \code{R.utils::withTimeout(  , timeout = getOption("reproducible.timeout"))}
will be wrapped around the download so that it will timeout (and error) after this many
seconds.
}
\item{\code{useCache}}{
Default: \code{TRUE}. Used in \code{\link[=Cache]{Cache()}}. If \code{FALSE}, then the entire
\code{Cache} machinery is skipped and the functions are run as if there was no Cache occurring.
Can also take 2 other values: \code{'overwrite'} and \code{'devMode'}.
\code{'overwrite'} will cause no recovery of objects from the cache repository, only new
ones will be created. If the hash is identical to a previous one, then this will overwrite
the previous one.
\code{'devMode'} will function as normally \code{Cache} except it will use the
\code{userTags} to determine if a previous function has been run. If the \code{userTags}
are identical, but the digest value is different, the old value will be deleted from the
cache repository and this new value will be added.
This addresses a common situation during the development stage: functions are changing
frequently, so any entry in the cache repository will be stale following changes to
functions, i.e., they will likely never be relevant again.
This will therefore keep the cache repository clean of stale objects.
If there is ambiguity in the \code{userTags}, i.e., they do not uniquely identify a single
entry in the \code{cachePath}, then this option will default back to the non-dev-mode
behaviour to avoid deleting objects.
This, therefore, is most useful if the user is using unique values for \code{userTags}.
}
\item{\code{useCloud}}{
Default \code{FALSE}. Passed to \code{Cache}.
}
\item{\code{useDBI}}{
Default: \code{TRUE} if \pkg{DBI} is available.
Default value can be overridden by setting environment variable \code{R_REPRODUCIBLE_USE_DBI}.
As of version 0.3, the backend is now \pkg{DBI} instead of \pkg{archivist}.
}
\item{\code{useGdown}}{
Default: \code{FALSE}. If a user provides a Google Drive url to \code{preProcess}/\code{prepInputs},
\code{reproducible} will use the \code{googledrive} package. This works reliably in most cases.
However, for large files on unstable internet connections, it will stall and
stop the download with no error. If a user is finding this behaviour, they can
install the \code{gdown} package, making sure it is available on the PATH. This call
to \code{gdown} will only work for files that do not need authentication. If authentication
is needed, \code{dlGoogle} will fall back to \code{googledrive::drive_download}, even
if this option is \code{TRUE}, with a message.
.
}
\item{\code{useMemoise}}{
Default: \code{FALSE}. Used in \code{\link[=Cache]{Cache()}}. If \code{TRUE}, recovery of cached
elements from the \code{cachePath} will use \code{memoise::memoise}.
This means that the 2nd time running a function will be much faster than the first
in a session (which either will create a new cache entry to disk or read a cached
entry from disk).
\emph{NOTE: memoised values are removed when the R session is restarted}.
\strong{This option will use more RAM} and so may need to be turned off if RAM is limiting.
\code{clearCache} of any sort will cause all memoising to be 'forgotten' (\code{memoise::forget}).
}
\item{\code{useNewDigestAlgorithm}}{
Default: \code{1}. Option 1 is the version that has existed for sometime.
There is now an option \code{2} which is substantially faster.
It will, however, create Caches that are not compatible with previous ones.
Options \code{1} and \code{2} are not compatible with the earlier \code{0}.
\code{1} and \code{2} will make \code{Cache} less sensitive to minor but irrelevant changes
(like changing the order of arguments) and will work successfully across operating systems
(especially relevant for the new \code{cloudCache} function.
}
\item{\code{useTerra}}{
Default: \code{FALSE}. The GIS operations in postProcess, by default use primarily
the Raster package. The newer terra package does similar operations, but usually
faster. A user can now set this option to \code{TRUE} and \code{prepInputs}
and several components of \code{postProcess} will use \code{terra} internally.
}
\item{\code{verbose}}{
Default: \code{FALSE}. If set to \code{TRUE} then every \code{Cache} call will show a
summary of the objects being cached, their \code{object.size} and the time it took to digest
them and also the time it took to run the call and save the call to the cache repository or
load the cached copy from the repository.
This may help diagnosing some problems that may occur.
}
}
}
\section{Advanced}{

The following options are likely not needed by a user.
\describe{
\item{\code{cloudChecksumsFilename}}{
Default: \code{file.path(dirname(.reproducibleTempCacheDir()), "checksums.rds")}.
Used as an experimental argument in \code{\link[=Cache]{Cache()}}
}
\item{\code{length}}{
Default: \code{Inf}. Used in \code{\link[=Cache]{Cache()}}, specifically to the internal
calls to \code{\link[=CacheDigest]{CacheDigest()}}. This is passed to \code{digest::digest}.
Mostly this would be changed from default \code{Inf} if the digesting is taking too long.
Use this with caution, as some objects will have \emph{many} \code{NA} values in their first
\emph{many} elements
}
\item{\code{useragent}}{
Default: \code{"https://github.com/PredictiveEcology/reproducible"}.
User agent for downloads using this package.
}
}
}

