% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/entrez_info.r
\name{entrez_info}
\alias{entrez_info}
\title{Get infromation about EUtils databases}
\usage{
entrez_info(db = NULL, config = NULL)
}
\arguments{
\item{db}{characater database about which to retrieve information (optional,}

\item{config}{config vector passed on to \code{httr::GET}}
}
\value{
XMLInternalDocument with information describing either all the
databases available in Eutils (if db is not set) or one particular database
(set by 'db')
}
\description{
Constructs a query to NCBI's einfo and returns a parsed XML object
Note: The most common uses-cases for the einfo util are finding the list of
search fields available for a given database or the other NCBI databases to
which records in a given database might be linked. Both these use cases
are implemented in higher-level functions that return just this information
(\code{entrez_db_searchable} and \code{entrez_db_links} respectively).
Consequently most users will not have a reason to use this function (though
it is exported by \code{rentrez} for the sake of completeness.
}
\examples{
all_the_data <- entrez_info()
xpathSApply(all_the_data, "//DbName", xmlValue)
entrez_dbs()
}
\seealso{
\code{\link[httr]{config}} for available httr configurations

Other einfo: \code{\link{entrez_db_links}};
  \code{\link{entrez_db_searchable}};
  \code{\link{entrez_db_summary}}; \code{\link{entrez_dbs}}
}

