% Generated by roxygen2 (4.0.0): do not edit by hand
\name{entrez_post}
\alias{entrez_post}
\title{Post IDs to Eutils for later use}
\usage{
entrez_post(db, id, config = NULL, ...)
}
\arguments{
\item{db}{character Name of the database from which the IDs were taken}

\item{id}{integer ID(s) for which data is being collected}

\item{\dots}{character Additional terms to add to the request}

\item{config}{vector configuration options passed to httr::GET}
}
\value{
QueryKey integer identifier for specific query in webhistory

WebEnv character identifier for session key to use with history
}
\description{
Post IDs to Eutils for later use
}
\examples{
\dontrun{
so_many_snails <- entrez_search(db="nuccore",
                      "Gastropoda[Organism] AND COI[Gene]", retmax=200)
upload <- entrez_post(db="nuccore", id=so_many_snails$ids)
cookie <- upload$WebEnv
first <- entrez_fetch(db="nuccore", file_format="fasta", WebEnv=cookie,
                      query_key=upload$QueryKey, retend=10)
second <- entrez_fetch(db="nuccore", file_format="fasta", WebEnv=cookie,
                       query_key=upload$QueryKey, retstart=10)
}
}
\seealso{
\code{\link[httr]{config}} for avaliable configs
}

