% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/refset.R
\name{wrap}
\alias{wrap}
\title{Wrap an expression and its environment into a parcel.}
\usage{
wrap(expr, env = parent.frame())
}
\arguments{
\item{expr}{an R expression}

\item{env}{environment in which \code{expr} is to be evaluated}
}
\value{
An object of class 'parcel', with components \code{expr} and \code{env}.
}
\description{
Refsets (and other active bindings) cannot be passed as function
arguments, since doing so makes a copy. \code{wrap} allows you to pass
arbitrary expressions between functions and records where they are
ultimately evaluated.
}
\examples{
dfr <- data.frame(a=1:4, b=1:4)
rs \%r\% dfr[1:2,]
parcel <- wrap(rs)
f <- function (parcel) contents(parcel) <- contents(parcel)*2
f(parcel)
contents(parcel)
dfr

parcel <- wrap(x^2) # non-refset use
x <- 3
f <- function(parcel) {x <- 10; contents(parcel)}
f(parcel)
}
\seealso{
Other wrapping functions: \code{\link{contents}},
  \code{\link{contents<-}}; \code{\link{is.parcel}};
  \code{\link{unwrap_as}}; \code{\link{wrapset}}
}

