% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/redist.R
\name{redist.combine}
\alias{redist.combine}
\title{Combine successive runs of \code{redist.mcmc}}
\usage{
redist.combine(savename, nsims, nloop, nthin, nunits, temper)
}
\arguments{
\item{savename}{The name (without the loop or \code{.RData} suffix)
of the saved simulations.}

\item{nsims}{The number of simulations in each loop.}

\item{nloop}{The number of loops being combined.}

\item{nthin}{How much to thin the simulations being combined.}

\item{nunits}{The number of geographic units from the simulations.}

\item{temper}{Wheterh simulated tempering was used (1) or not (0)
in the simulations. Default is 0.}
}
\value{
\code{redist.combine} returns an object of class "redist". The object
\code{redist} is a list that contains the folowing components (the
inclusion of some components is dependent on whether tempering
techniques are used):
\item{partitions}{Matrix of congressional district assignments generated by the
algorithm. Each row corresponds to a geographic unit, and each column
corresponds to a simulation.}
\item{distance_parity}{Vector containing the maximum distance from parity for
a particular simulated redistricting plan.}
\item{mhdecisions}{A vector specifying whether a proposed redistricting plan
was accepted (1) or rejected (0) in a given iteration.}
\item{mhprob}{A vector containing the Metropolis-Hastings acceptance
probability for each iteration of the algorithm.}
\item{pparam}{A vector containing the draw of the \code{p} parameter for each
simulation, which dictates the number of swaps attempted.}
\item{constraint_pop}{A vector containing the value of the population
constraint for each accepted redistricting plan.}
\item{constraint_compact}{A vector containing the value of the compactness
constraint for each accepted redistricting plan.}
\item{constraint_segregation}{A vector containing the value of the
segregation constraint for each accepted redistricting plan.}
\item{constraint_similar}{A vector containing the value of the similarity
constraint for each accepted redistricting plan.}
\item{beta_sequence}{A vector containing the value of beta for each iteration
of the algorithm. Returned when tempering is being used.}
\item{mhdecisions_beta}{A vector specifying whether a proposed beta value was
accepted (1) or rejected (0) in a given iteration of the algorithm. Returned
when tempering is being used.}
\item{mhprob_beta}{A vector containing the Metropolis-Hastings acceptance
probability for each iteration of the algorithm. Returned when tempering
is being used.}
}
\description{
\code{redist.combine} is used to combine successive runs of \code{redist.mcmc}
into a single data object
}
\details{
This function allows users to combine multiple successive runs of
\code{redist.mcmc} into a single \code{redist} object for analysis.
}
\examples{
\dontrun{
data(algdat.pfull)

## Code to run the simulations in Figure 4 in Fifield, Higgins,Imai and
Tarr (2015)

## Get an initial partition
set.seed(1)
initcds <- algdat.pfull$cdmat[,sample(1:ncol(algdat.pfull$cdmat), 1)]

## Run the algorithm
alg_253 <- redist.mcmc(adjobj = algdat.pfull$adjlist,
popvec = algdat.pfull$precinct.data$pop,
initcds = initcds,
nsims = 10000, nloops = 2, savename = "test")
out <- redist.combine(savename = "test", nsims = 10000, nloop = 2,
nthin = 10, nunits = length(algdat.pfull$adjlist))
}
}
\references{
Fifield, Benjamin, Michael Higgins, Kosuke Imai and Alexander Tarr.
(2016) "A New Automated Redistricting Simulator Using Markov Chain Monte
Carlo." Working Paper. Available at
\url{http://imai.princeton.edu/research/files/redist.pdf}.
}
