% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/docsSurveyMethods.R,
%   R/exportSurveyParticipants.R, R/exportSurveyLink.R,
%   R/exportSurveyQueueLink.R, R/exportSurveyReturnCode.R
\name{surveyMethods}
\alias{surveyMethods}
\alias{exportSurveyParticipants}
\alias{exportSurveyLink}
\alias{exportSurveyQueueLink}
\alias{exportSurveyReturnCode}
\alias{exportSurveyParticipants.redcapApiConnection}
\alias{exportSurveyLink.redcapApiConnection}
\alias{exportSurveyQueueLink.redcapApiConnection}
\alias{exportSurveyReturnCode.redcapApiConnection}
\title{Export Survey Participant Information}
\usage{
exportSurveyParticipants(rcon, instrument, event, ...)

exportSurveyLink(rcon, record, instrument, event, repeat_instance = 1, ...)

exportSurveyQueueLink(rcon, record, ...)

exportSurveyReturnCode(
  rcon,
  record,
  instrument,
  event,
  repeat_instance = 1,
  ...
)

\method{exportSurveyParticipants}{redcapApiConnection}(rcon, instrument = NULL, event = NULL, ...)

\method{exportSurveyLink}{redcapApiConnection}(
  rcon,
  record,
  instrument,
  event = NULL,
  repeat_instance = 1,
  ...
)

\method{exportSurveyQueueLink}{redcapApiConnection}(rcon, record, ...)

\method{exportSurveyReturnCode}{redcapApiConnection}(
  rcon,
  record,
  instrument,
  event = NULL,
  repeat_instance = 1,
  ...
)
}
\arguments{
\item{rcon}{A \code{redcapConnection} object.}

\item{record}{\code{character(1)} or \code{integerish(1)}. The record ID of a
survey participant.}

\item{instrument}{\code{character(1)}. The name of a survey instrument.}

\item{event}{\code{character(1)} The event name of the event for which
participant information should be exported.}

\item{repeat_instance}{\code{integerish(1)}. The repeat instance if the
instrument is designated as a repeating instrument. Default value is \code{1}.}

\item{...}{Arguments to pass to other methods}
}
\value{
\code{exportSurveyParticipants} returns a data frame with the columns:\tabular{ll}{
    \tab  \cr
   \code{email} \tab The e-mail address of the participant. \cr
   \code{email_occurrence} \tab The number of times the invitation has been sent (after the next invite). \cr
   \code{identifier} \tab Participant identifier (if it exists) to match the survey response to a participant. \cr
   \code{record} \tab Record ID of the participant. \cr
   \code{invitation_sent_status} \tab Boolean value indicating if a survey invitation has been sent. \cr
   \code{invitation_send_time} \tab Date/time the survey invitation was sent. \cr
   \code{response_status} \tab Boolean value indicating if the participant has responded. \cr
   \code{survey_access_code} \tab The participant's survey access code. \cr
   \code{survey_link} \tab The participant's survey link. \cr
   \code{survey_queue_link} \tab The participants' survey queue link. \cr
}


\code{exportSurveyLink} returns a \code{character(1)} giving the link for the user
to access the survey form.

\code{exportSurveyQueueLink} returns a \code{character(1)} giving the survey queue
link for the user.

\code{exportSurveyReturnCode} returns a \code{character(1)} giving the survey return
code for the user.
}
\description{
These methods enable the user to export information relating
to survey participants.
}
\section{Functions}{
\itemize{
\item \code{exportSurveyParticipants()}: Export survey participants for a survey instrument.

\item \code{exportSurveyLink()}: Export a survey participant's survey instrument link.

\item \code{exportSurveyQueueLink()}: Export a survey participant's survey queue link.

\item \code{exportSurveyReturnCode()}: Export a survey participant's instrument return code.

}}
\examples{
\dontrun{
unlockREDCap(connections = c(rcon = "project_alias"), 
             url = "your_redcap_url", 
             keyring = "API_KEYs", 
             envir = globalenv())
             
# Export survey participants
exportSurveyParticipants(rcon, 
                         instrument = "survey_form")
                         
# Export survey participants for an event
exportSurveyParticipants(rcon, 
                         instrument = "survey_form", 
                         event = "event_1_arm_1")
                         
# Export survey link
exportSurveyLink(rcon, 
                 record = 1, 
                 instrument = "survey_form")
                 
# Export survey queue link
exportSurveyQueueLink(rcon, 
                      record = 1)
                      
# Export survey return code
exportSurveyReturnCode(rcon, 
                       user = 1, 
                       instrument = "survey_form")
}

}
