% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/readMeta.R
\name{readMeta}
\alias{readMeta}
\title{Process data from the DWD CDC FTP Server}
\usage{
readMeta(file, progbar = TRUE, ...)
}
\arguments{
\item{file}{Char (vector): name(s) of the zip file(s) downloaded with \code{\link[=dataDWD]{dataDWD()}},
e.g. "~/DWDdata/tageswerte_KL_02575_akt.zip"}

\item{progbar}{Logical: present a progress bar with estimated remaining time?
If missing and length(file)==1, progbar is internally set to FALSE.
DEFAULT: TRUE}

\item{\dots}{Further arguments passed to \code{\link[=read.table]{read.table()}}}
}
\value{
Invisible named list of data.frames; or a list of lists, if length(file)>1.
}
\description{
Read climate meta info textfiles in zip folders downloaded with \code{\link[=dataDWD]{dataDWD()}}.
}
\examples{
# see dataDWD

}
\seealso{
\code{\link[=dataDWD]{dataDWD()}}, \code{\link[=readVars]{readVars()}}, \code{\link[=readDWD]{readDWD()}}
}
\author{
Berry Boessenkool, \email{berry-b@gmx.de}, 2016 + March 2019
}
\keyword{file}
