% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rdf.R
\name{rdf}
\alias{rdf}
\title{Initialize an \code{rdf} Object}
\usage{
rdf(storage = c("memory", "BDB"), path = ".", new_db = FALSE)
}
\arguments{
\item{storage}{Use in-memory hashes ("memory"), or disk based storage ("BDB")?}

\item{path}{where should local database to store RDF triples be created, if
configured for disk-based storage; see details.}

\item{new_db}{logical, default FALSE. should we create a new database on disk
or attempt to connect to an existing database (at the path specified)?}
}
\value{
an rdf object
}
\description{
Initialize an \code{rdf} Object
}
\details{
an rdf Object is a list of class 'rdf', consisting of
three pointers to external C objects managed by the redland library.
These are the \code{world} object: basically a top-level pointer for
all RDF models, and a \code{model} object: a collection of RDF statements,
and a \code{storage} object, indicating how these statements are stored.

\code{rdflib} defaults to an in-memory hash-based storage structure.
which should be best for most use cases. For very large triplestores,
disk-based storage will be necessary. set \code{storage="BDB"} to use disk-based
storage. Specify a path with the optional \code{path} argument, default uses
the current working directory. Disk-based storage requires redland package
to be installed from source with support for the Berkeley DB
(libdb-dev on Ubuntu, berkeley-db on homebrew), otherwise this will
fall back to in-memory storage with a warning. Check for working BDB
support with the function \code{rdf_has_bdb()}.

Typical use will be simply to initialize a container to which
the user would manually add triples using \code{\link{rdf_add}}.
}
\examples{
x <- rdf()

}
