% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/variables.R
\name{ddi_var}
\alias{ddi_var}
\alias{ddi_catLevel}
\alias{ddi_codInstr}
\alias{ddi_geomap}
\alias{ddi_qstn}
\alias{ddi_stdCatgry}
\alias{ddi_sumStat}
\alias{ddi_TotlResp}
\alias{ddi_undocCod}
\alias{ddi_varFormat}
\title{var and its child nodes}
\usage{
ddi_var(varname, ...)

ddi_catLevel(...)

ddi_codInstr(...)

ddi_geomap(...)

ddi_qstn(...)

ddi_stdCatgry(...)

ddi_sumStat(...)

ddi_TotlResp(...)

ddi_undocCod(...)

ddi_varFormat(...)
}
\arguments{
\item{varname}{The variable name.}

\item{...}{Child nodes or attributes.}
}
\value{
A ddi_node object.
}
\description{
This element describes all of the features of a single variable in a social
science data file. The following elements are repeatable to support
multi-language content: anlysUnit, embargo, imputation, respUnit, security,
TotlResp. More information on these elements, especially their allowed
attributes, can be found in the references.
}
\details{
\emph{Parent nodes}

\code{var} is contained in \code{dataDscr}.

\emph{var specific child nodes}
\itemize{
\item \code{ddi_catLevel()} is used to describe the levels of the category hierarchy.
\item \code{ddi_codInstr()} are coder instructions. These are any special instructions
to those who converted information from one form to another for a particular
variable. This might include the reordering of numeric information into
another form or the conversion of textual information into numeric information.
\item \code{ddi_geomap()} is a geographic map. This element is used to point, using a
"URI" attribute, to an external map that displays the geography in question.
\item \code{ddi_qstn()} is the question asked. The element may have mixed content. The
element itself may contain text for the question, with the subelements being
used to provide further information about the question. Alternatively, the
question element may be empty and only the subelements used. The element has
a unique question ID attribute which can be used to link a variable with
other variables where the same question has been asked. This would allow
searching for all variables that share the same question ID, perhaps because
the questions was asked several times in a panel design.
\item \code{ddi_stdCatgry()} are standard category codes used in the variable, like
industry codes, employment codes, or social class codes.
\item \code{ddi_sumStat()} is one or more statistical measures that describe the
responses to a particular variable and may include one or more standard
summaries, e.g., minimum and maximum values, median, mode, etc.
\item \code{ddi_TotlResp()} are the number of responses to this variable. This element
might be used if the number of responses does not match added case counts.
It may also be used to sum the frequencies for variable categories.
\item \code{ddi_undocCod()} is the list of undocumented codes where the meaning of the
values are unknown.
\item \code{ddi_varFormat()} is the technical format of the variable in question.
}
}
\section{Shared and complex child nodes}{

\itemize{
\item \code{\link[=ddi_anlysUnit]{ddi_anlysUnit()}}
\item \code{\link[=ddi_catgry]{ddi_catgry()}}
\item \code{\link[=ddi_catgryGrp]{ddi_catgryGrp()}}
\item \code{\link[=ddi_concept]{ddi_concept()}}
\item \code{\link[=ddi_derivation]{ddi_derivation()}}
\item \code{\link[=ddi_embargo]{ddi_embargo()}}
\item \code{\link[=ddi_imputation]{ddi_imputation()}}
\item \code{\link[=ddi_invalrng]{ddi_invalrng()}}
\item \code{\link[=ddi_labl]{ddi_labl()}}
\item \code{\link[=ddi_location]{ddi_location()}}
\item \code{\link[=ddi_notes]{ddi_notes()}}
\item \code{\link[=ddi_respUnit]{ddi_respUnit()}}
\item \code{\link[=ddi_security]{ddi_security()}}
\item \code{\link[=ddi_txt]{ddi_txt()}}
\item \code{\link[=ddi_universe]{ddi_universe()}}
\item \code{\link[=ddi_valrng]{ddi_valrng()}}
\item \code{\link[=ddi_verStmt]{ddi_verStmt()}}
}
}

\examples{
ddi_var(varname = "var01")

# Functions that need to be wrapped in ddi_var()

ddi_catLevel(ID = "Level1", levelnm = "Broader sectors")

ddi_codInstr("Use the standard classification tables to present responses to 
              the question: What is your occupation? into numeric codes.")
              
ddi_geomap(URI = "https://mapURL.com")

ddi_qstn(ID = "Q125",
         "When you get together with your friends, would you say you discuss 
         political matters frequently, occasionally, or never?")
         
ddi_stdCatgry(date = "1981",
              "U. S. Census of Population and Housing, Classified Index of 
              Industries and Occupations")
              
ddi_sumStat(type = "min", "0")

ddi_TotlResp("1,056")

ddi_undocCod("Responses for categories 9 and 10 are unavailable.")

ddi_varFormat(type = "numeric",
              formatname = "date.iso8601",
              schema = "XML-Data",
              category = "date",
              URI = "http://www.w3.org/TR/1998/NOTE-XML-data/",
              "19541022")

}
\references{
\href{https://ddialliance.org/Specification/DDI-Codebook/2.5/XMLSchema/field_level_documentation_files/schemas/codebook_xsd/elements/var.html}{var documentation}

\href{https://ddialliance.org/Specification/DDI-Codebook/2.5/XMLSchema/field_level_documentation_files/schemas/codebook_xsd/elements/catLevel.html}{catLevel documentation}

\href{https://ddialliance.org/Specification/DDI-Codebook/2.5/XMLSchema/field_level_documentation_files/schemas/codebook_xsd/elements/codInstr.html}{codInstr documentation}

\href{https://ddialliance.org/Specification/DDI-Codebook/2.5/XMLSchema/field_level_documentation_files/schemas/codebook_xsd/elements/geoMap.html}{geomap documentation}

\href{https://ddialliance.org/Specification/DDI-Codebook/2.5/XMLSchema/field_level_documentation_files/schemas/codebook_xsd/elements/qstn.html}{qstn documentation}

\href{https://ddialliance.org/Specification/DDI-Codebook/2.5/XMLSchema/field_level_documentation_files/schemas/codebook_xsd/elements/stdCatgry.html}{stdCatgry documentation}

\href{https://ddialliance.org/Specification/DDI-Codebook/2.5/XMLSchema/field_level_documentation_files/schemas/codebook_xsd/elements/sumStat.html}{sumStat documentation}

\href{https://ddialliance.org/Specification/DDI-Codebook/2.5/XMLSchema/field_level_documentation_files/schemas/codebook_xsd/elements/TotlResp.html}{TotlResp documentation}

\href{https://ddialliance.org/Specification/DDI-Codebook/2.5/XMLSchema/field_level_documentation_files/schemas/codebook_xsd/elements/undocCod.html}{undocCod documentation}

\href{https://ddialliance.org/Specification/DDI-Codebook/2.5/XMLSchema/field_level_documentation_files/schemas/codebook_xsd/elements/varFormat.html}{varFormat documentation}
}
