% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/taxon_references.R
\name{taxon_references}
\alias{taxon_references}
\title{Get references for a given taxon concept}
\usage{
taxon_references(tax_id, type = c("taxonomic", "distribution"),
  simplify = FALSE, token = NULL)
}
\arguments{
\item{tax_id}{character string containing a species' taxon concept identifier
(see \code{\link[rcites]{sppplus_taxonconcept}}).}

\item{type}{vector of character strings indicating the type of references
requested, \code{taxonomic} or \code{distribution}.}

\item{simplify}{a logical. Should the output be simplified? In other words,
should columns of data.table objects returned be unlisted when they are
lists made of single elements?}

\item{token}{a character string containing the authentification token, see
\url{https://api.speciesplus.net/documentation}. Default is set to
\code{NULL} and requires the environment variable \code{SPPPLUS_TOKEN} to be
set directly in \code{Renviron}. Alternatively \code{sppplus_login()} can
be used to set \code{SPPPLUS_TOKEN} for the current session.}
}
\value{
A list of data.table objects, one per type requested.
}
\description{
Retrieve available references for a given taxon concept.
}
\examples{
\donttest{
res1 <- taxon_references(tax_id = '4521')
res2 <- taxon_references(tax_id = '4521', type = 'taxonomic', simplify = T)
}
}
\references{
\url{https://api.speciesplus.net/documentation/v1/references/index.html}
}
