% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/init_rc.R
\name{init_rc}
\alias{init_rc}
\title{Set initial values for Rogers-Castro migration model}
\usage{
init_rc(
  ages,
  net_mig,
  pop,
  pre_working_age,
  working_age,
  retirement,
  post_retirement,
  nchains = 4
)
}
\arguments{
\item{ages}{numeric. A vector of integers for ages.}

\item{net_mig}{numeric. A vector of integers for observed age-specific net migrants.}

\item{pop}{numeric. A vector of integers for age-specific population.}

\item{pre_working_age}{logical (TRUE/FALSE). Whether or not you are including pre working age component.}

\item{working_age}{logical (TRUE/FALSE). Whether or not you are including working age component.}

\item{retirement}{logical (TRUE/FALSE). Whether or not you are including retirement age component.}

\item{post_retirement}{logical (TRUE/FALSE). Whether or not you are including post retirement age component.}

\item{nchains}{numeric. A positive integer specifying the number of Markov chains. Should be 4 unless changed otherwise.}
}
\value{
A list of length \code{nchains}. Each element of the list is a list of numeric values.
Within the inner lists, there is one element for every model parameter.
}
\description{
Choose initial values for parameters in the Rogers-Castro model in a strategic way based on your data.
Provide these initial values to improve convergence of model. Intended to be used with rcbayes::mig_estimate_rc as
an additional input into 'Stan'.
}
\examples{
# define ages, net migrants, and population
ages <- 0:80
net_mig <- c(202,215,167,188,206,189,164,
            158,197,185,176,173,167,198,
            203,237,249,274,319,345,487,
            491,521,505,529,527,521,529,
            507,484,467,439,399,399,380,
            368,310,324,289,292,270,269,
            285,254,245,265,257,258,263,
            253,346,293,332,346,349,355,
            386,346,344,352,331,320,307,
            320,310,258,254,243,256,263,
            183,169,172,160,166,113,132,
            111,130,110,113)
pop <- c(105505,105505,105505,105505,105505,
        106126,106126,106126,106126,106126,
        100104,100104,100104,100104,100104,
        114880,114880,114880,114880,114880,
        136845,136845,136845,136845,136845,
        136582,136582,136582,136582,136582,
        141935,141935,141935,141935,141935,
        134097,134097,134097,134097,134097,
        130769,130769,130769,130769,130769,
        133718,133718,133718,133718,133718,
        154178,154178,154178,154178,154178,
        145386,145386,145386,145386,145386,
        126270,126270,126270,126270,126270,
        108314,108314,108314,108314,108314,
        79827,79827,79827,79827,79827,59556,
        59556,59556,59556,59556,59556)

#compute initial values
iv <- init_rc(ages, net_mig, pop, pre_working_age=TRUE,
             working_age=TRUE, retirement=TRUE, post_retirement=TRUE)

}
