% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/interpolate_sky_points.R
\name{interpolate_sky_points}
\alias{interpolate_sky_points}
\title{Interpolate sky points}
\usage{
interpolate_sky_points(sky_points, g, k = 3, p = 2, rmax = 200, col_id = "rl")
}
\arguments{
\item{sky_points}{An object of class \emph{data.frame}. The result of a call
to \code{\link{extract_rl}} or \code{\link{extract_dn}}, or a
\emph{data.frame} with same basic structure and names.}

\item{g}{\linkS4class{SpatRaster} built with
\code{\link{sky_grid_segmentation}} or \code{\link{chessboard}}.}

\item{k}{Numeric vector of length one. Number of k-nearest neighbors.}

\item{p}{Numeric vector of length one. Power for inverse-distance weighting.}

\item{rmax}{Numeric vector of length one. Maximum radius where to search for
knn.}

\item{col_id}{Numeric vector of length one. ID of the column with the values
to interpolate.}
}
\value{
An object of class \linkS4class{SpatRaster}.
}
\description{
Interpolate values from canopy photographs.
}
\details{
This function use \code{\link[lidR]{knnidw}} as workhorse function, so
arguments \code{k}, \code{p}, and \code{rmax} are passed to it.

This method is based on \insertCite{Lang2010;textual}{rcaiman}. In theory,
interpolation requires a linear relation between DNs and the amount of light
reaching the sensor. To that end, photographs should be taken in RAW format
to avoid gamma correction \insertCite{Lang2010}{rcaiman}. As a compromise
solution, \code{\link{gbc}} can be used.

The vignetting effect also hinders the linear relation between DNs and the
amount of light reaching the sensor. Please refer to
\insertCite{Lang2010;textual}{rcaiman} for more details about the vignetting
effect.

The use of \code{k = 1} solves the linear dilemma from the theoretical point
of view since no averaging is taking place in the calculations. However,
probably, it is best to use \code{k} greater than 1.

Default parameters are the ones used by
\insertCite{Lang2010;textual}{rcaiman}. The argument \code{rmax} should
account for between 15 to 20 degrees, but it is expressed in pixels units.
So, image resolution and lens projections should be taken into account to set
this argument properly.

The argument \code{g} should be the same used to obtain \code{sky_points}.
The result will be limited to the cells with at least one pixel covered by
the convex hull of the sky points.
}
\examples{
\dontrun{
caim <- read_caim() \%>\% normalize()
z <- zenith_image(ncol(caim), lens("Nikon_FCE9"))
a <- azimuth_image(z)
bin <- ootb_obia(caim, z, a)

g <- sky_grid_segmentation(z, a, 10)
r <- gbc(caim$Blue*255)
sky_points <- extract_sky_points(r, bin, g)
sky_points <- extract_rl(r, z, a, sky_points, NULL)
sky <- interpolate_sky_points(sky_points$sky_points, g)
plot(sky)

#modify g if the goal is to get the whole sky
g <- !is.na(z)
sky <- interpolate_sky_points(sky_points$sky_points, g)
plot(sky)
plot(r/sky)

#restricted view canopy photo
path <- system.file("external/APC_0020.jpg", package = "rcaiman")
caim <- read_caim(path)
plot(caim)
r <- gbc(caim$Blue)
caim <- normalize(caim)

bin <- ootb_obia(caim)

g <- chessboard(caim, 100)
plot(g)
sky_points <- extract_sky_points(r, bin, g)
sky_points <- extract_dn(r, sky_points)
head(sky_points)
sky <- interpolate_sky_points(sky_points, !is.na(r), col_id = 3)
plot(sky)
plot(r/sky)
}
}
\references{
\insertAllCited{}
}
\seealso{
Other Sky Reconstruction Functions: 
\code{\link{cie_sky_model_raster}()},
\code{\link{fit_cie_sky_model}()},
\code{\link{fit_coneshaped_model}()},
\code{\link{fit_trend_surface}()},
\code{\link{fix_reconstructed_sky}()},
\code{\link{ootb_sky_reconstruction}()}
}
\concept{Sky Reconstruction Functions}
