% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nbt.R
\name{get_nbt_data}
\alias{get_nbt_data}
\alias{get_nbt_value}
\alias{put_nbt_data}
\alias{put_nbt_value}
\alias{read_nbt}
\alias{read_nbt_data}
\alias{write_nbt}
\alias{write_nbt_data}
\title{Read and Write NBT Data}
\usage{
get_nbt_data(keys, db = default_db(), readoptions = NULL, simplify = TRUE)

get_nbt_value(key, db = default_db(), readoptions = NULL, simplify = TRUE)

put_nbt_data(values, keys, db = default_db(), writeoptions = NULL)

put_nbt_value(value, key, db = default_db(), writeoptions = NULL)

read_nbt(
  rawvalue,
  format = c("little", "big", "network", "network_big"),
  simplify = TRUE
)

read_nbt_data(
  rawdata,
  format = c("little", "big", "network", "network_big"),
  simplify = TRUE
)

write_nbt(value, format = c("little", "big", "network", "network_big"))

write_nbt_data(values, format = c("little", "big", "network", "network_big"))
}
\arguments{
\item{keys}{A character vector of keys}

\item{db}{A \code{bedrockdb} object}

\item{readoptions}{A \code{bedrock_leveldb_readoptions} object}

\item{simplify}{If TRUE, simplifies a list containing a single unnamed
nbt value.}

\item{key}{A single key}

\item{values}{A list of values. Optionally named.}

\item{writeoptions}{A \code{bedrock_leveldb_writeoptions} object}

\item{value}{An nbt object or a list of nbt objects}

\item{rawvalue}{A \code{raw} vector}

\item{format}{A character string specifying which binary NBT format to use.}

\item{rawdata}{A list of \code{raw} vectors}
}
\description{
The Named Binary Tag (NBT) format is used by Minecraft for various data
types.
}
\details{
\code{get_nbt_data()} and \code{get_nbt_value()} load nbt-formatted data from \code{db}
and parses it.

\code{put_nbt_data()} and \code{put_nbt_value()} store nbt data into \code{db} in binary
form.

\code{read_nbt()} reads NBT data from a \code{raw} vector.

\code{read_nbt_data()} calls \code{read_nbt()} on each element of a list.

\code{write_nbt()} encodes NBT data into a \code{raw} vector.

\code{write_nbt_data()} calls \code{write_nbt()} on each element of a list.
}
