% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tensor.R
\name{join_tensors}
\alias{join_tensors}
\title{Join Multiple Tensors into One Tensor}
\usage{
join_tensors(tensors, temporary = TRUE)
}
\arguments{
\item{tensors}{list of \code{\link{Tensor}} instances}

\item{temporary}{whether to garbage collect space when exiting R session}
}
\value{
A new \code{\link{Tensor}} instance with the last dimension
}
\description{
Join Multiple Tensors into One Tensor
}
\details{
Merges multiple tensors. Each tensor must share the same dimension
with the last one dimension as 1, for example, \code{100x100x1}. Join 3
tensors like this will result in a \code{100x100x3} tensor. This function
is handy when each sub-tensors are generated separately. However, it does no
validation test. Use with cautions.
}
\examples{
tensor1 <- Tensor$new(data = 1:9, c(3,3,1), dimnames = list(
A = 1:3, B = 1:3, C = 1
), varnames = c('A', 'B', 'C'))
tensor2 <- Tensor$new(data = 10:18, c(3,3,1), dimnames = list(
  A = 1:3, B = 1:3, C = 2
), varnames = c('A', 'B', 'C'))
merged <- join_tensors(list(tensor1, tensor2))
merged$get_data()

}
\author{
Zhengjia Wang
}
