% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/modify.R
\name{replace_model}
\alias{replace_model}
\title{Replace a model with new values}
\usage{
replace_model(l, path, model)
}
\arguments{
\item{l}{the list of apsimx file}

\item{path}{If numeric, the path returned by search_path or search_node. If character, the path supported by apsimx}

\item{model}{A new model}
}
\value{
The modified list with new value
}
\description{
Replace a model with new values
}
\examples{
wheat <- read_apsimx(system.file("Wheat.json", package = "rapsimng"))

a <- search_path(wheat, '[Wheat].Phenology.ThermalTime')
a$node$Children[[1]]$X[[2]] <- 27
wheat_new <- replace_model(wheat, a$path, a$node)
b <- search_path(wheat_new, '[Wheat].Phenology.ThermalTime')
b$node$Children[[1]]$X
}
