% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{docs_by_cluster_table}
\alias{docs_by_cluster_table}
\title{Returns, for each cluster, the number of source documents with at least n
segments of this cluster}
\usage{
docs_by_cluster_table(obj, clust_var = NULL, doc_id = NULL, threshold = 1)
}
\arguments{
\item{obj}{a corpus, tokens or dtm object}

\item{clust_var}{name of the docvar with the clusters}

\item{doc_id}{docvar identifying the source document}

\item{threshold}{the minimal number of segments of a given cluster that a document
must include to be counted}
}
\description{
Returns, for each cluster, the number of source documents with at least n
segments of this cluster
}
\details{
This function is only useful for previously segmented corpus. If \code{doc_id} is NULL
and there is a \code{sement_source} docvar, it will be used instead.
}
\examples{
\donttest{
require(quanteda)
corpus <- data_corpus_inaugural
corpus <- head(corpus, n = 10)
corpus <- split_segments(corpus)
tok <- tokens(corpus, remove_punct = TRUE)
tok <- tokens_remove(tok, stopwords("en"))
dtm <- dfm(tok, tolower = TRUE)
dtm <- dfm_trim(dtm, min_docfreq = 2)
res <- rainette(dtm, k = 3, min_segment_size = 15)
corpus$cluster <- cutree(res, k = 3)
docs_by_cluster_table(corpus, clust_var = "cluster")
}
}
\seealso{
\code{\link[=clusters_by_doc_table]{clusters_by_doc_table()}}
}
