% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/LASmetrics.r
\name{LASmetrics}
\alias{LASmetrics}
\title{LiDAR-derived metrics}
\usage{
LASmetrics(LASfile, minht, above)
}
\arguments{
\item{LASfile}{A LAS standard LiDAR data file}

\item{minht}{Use only returns above specified height break, e.g. 1.30 m. Default is 1.37 m.}

\item{above}{Compute covers metrics using specified height break, e.g. 2.5 m. Default is 2 m.}
}
\value{
Returns A matrix with the LiDAR-derived vegetation height and canopy cover metrics (see \emph{cloudmetrics}, in McGaughey, 2014)
}
\description{
Compute LiDAR metrics that describe statistically the Lidar dataset
}
\examples{

#=======================================================================#
# Example 01: Computing LiDAR metrics for a single LAS file
#=======================================================================#
# Import the LAS data file
LASfile <- system.file("extdata", "LASexample1.las", package="rLiDAR")

# Set the minht and above parameters
minht<-1.37  # meters or feet
above<-2.00  # meters or feet

# LiDAR metrics computation
LiDARmetrics<-LASmetrics(LASfile, minht, above)

#==========================================================================#
# Example 02: Computing Lidar metrics for multiple LAS files within a folder
#==========================================================================#
# Set folder where LAS source files reside
folder=dirname(LASfile)

# Get list of LAS files residing in the folder
LASlist <- list.files(folder, pattern="*.las", full.names=TRUE)

# Set the "minht" and "above" parameters
minht<-1.37  # meters or feet
above<-2.00  # meters or feet

# Creat an empty dataframe in whic to store the LiDAR metrics
getMetrics<-data.frame()

# Set a loop to compute the LiDAR metrics
for ( i in LASlist) {
 getMetrics<-rbind(getMetrics, LASmetrics(i, minht, above))}

# Table of the Lidar metrics
LiDARmetrics<-cbind(Files=c(basename(LASlist)), getMetrics)
head(LiDARmetrics)

}
\seealso{
McGaughey, R. 2014. FUSION/LDV: Software for lidar data analysis and visualization. Version 3.41. Seattle, WA: U.S. Department of Agriculture, Forest Service, Pacific Northwest Research Station.


# List of the LiDAR-derived metrics:
\itemize{ 
\item Total all return count   
\item Total first return count
\item Total all return count above \emph{minht}
\item Return 1 count above \emph{minht}
\item Return 2 count above \emph{minht}
\item Return 3 count above \emph{minht}
\item Return 5 count above \emph{minht}
\item Return 6 count above \emph{minht}
\item Return 7 count above \emph{minht}
\item Return 8 count above \emph{minht}
\item Return 9 count above \emph{minht}
\item HMIN - Maximum Height
\item HMAX - Maximum Height
\item HMEAN - Mean height
\item HMOD - Modal height
\item HMEDIAN - Median height
\item HSD - Standard deviation of heights
\item HVAR - Variance of heights
\item HCV - Coefficient of variation of heights
\item HKUR - Kurtosis of Heights
\item HSKE - Skewness of Heights
\item H01TH - 01th percentile of height
\item H05TH - 05th percentile of height
\item H10TH - 10th percentile of height
\item H15TH - 15th percentile of height
\item H20TH - 20th percentile of height
\item H25TH - 25th percentile of height
\item H30TH - 30th percentile of height
\item H35TH - 35th percentile of height
\item H40TH - 40th percentile of height
\item H45TH - 45th percentile of height
\item H50TH - 50th percentile of height
\item H55TH - 55th percentile of height
\item H60TH - 60th percentile of height
\item H65TH - 65th percentile of height
\item H70TH - 70th percentile of height
\item H75TH - 75th percentile of height
\item H80TH - 80th percentile of height
\item H90TH - 90th percentile of height
\item H95TH - 95th percentile of height
\item H99TH - 99th percentile of height
\item CRR - Canopy relief ratio
\item IMIN - Minimum intensity
\item IMAX - Maximum intensity
\item IMEAN - Mean intensity
\item IMOD - Modal intensity
\item IMEDIAN - Median intensity
\item ISD - Standard deviation of intensities
\item IVAR - Variance of heights
\item ICV - Coefficient of variation of intensities
\item IKUR - Kurtosis of intensities
\item ISKE - Skewness of intensities
\item I01TH - 1th percentile of intensity
\item I05TH - 5th percentile of intensity
\item I10TH - 10th percentile of intensity
\item I15TH - 15th percentile of intensity
\item I20TH - 20th percentile of intensity
\item I25TH - 25th percentile of intensity
\item I30TH - 30th percentile of intensity
\item I35TH - 35th percentile of intensity
\item I40TH - 40th percentile of intensity
\item I45TH - 45th percentile of intensity
\item I50TH - 50th percentile of intensity
\item I55TH - 55th percentile of intensity
\item I60TH - 60th percentile of intensity
\item I65TH - 65th percentile of intensity
\item I70TH - 70th percentile of intensity
\item I75TH - 75th percentile of intensity
\item I80TH - 80th percentile of intensity
\item I90TH - 90th percentile of intensity
\item I95TH - 95th percentile of intensity
\item I99TH - 99th percentile of intensity
\item Pentage first returns above \emph{above}
\item Percentage all returns above \emph{above}
\item (All returns above above / Total first returns)*100
\item First returns above \emph{above}
\item All returns above \emph{above}
\item Percentage first returns above mean
\item Percentage first returns above mode
\item Percentage all returns above mean
\item Percentage all returns above mode
\item (All returns above mean / Total first returns)*100
\item (All returns above mode / Total first returns)* 100
\item First returns above mean"
\item First returns above mode
\item All returns above mean
\item All returns above mode
}
}
\author{
Carlos Alberto Silva
}
