% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/class_ValueAxis.R
\docType{methods}
\name{initialize,ValueAxis-method}
\alias{initialize,ValueAxis-method}
\alias{setTitle,ValueAxis,character-method}
\alias{valueAxis}
\title{Initializes ValueAxis}
\usage{
\S4method{initialize}{ValueAxis}(.Object, title, guides, ...)

valueAxis(...)

\S4method{setTitle}{ValueAxis,character}(.Object, title)
}
\arguments{
\item{.Object}{\linkS4class{ValueAxis}.}

\item{title}{\code{character}.}

\item{guides}{\code{list} of \linkS4class{Guide}.}

\item{...}{Other properties (depend of call function)}
}
\description{
Creates a ValuesAxis or updates its properties.
}
\examples{

guides <- list(guide(fillAlpha = .4), guide(fillAlpha = .5))
new("ValueAxis", title = "Hello !",  gridThickness = 1, guides = guides)

\dontrun{
new("ValueAxis", title = "Hello !", 1) # 1 is not take into account

# If one element of guides is not a Guide object, it shows an error
guides <- list(guide(fillAlpha = .4), b = 1)
new("ValueAxis", title = "Hello !",  gridThickness = 1, guides = guides)
}

valueAxis(title = "Hello !", axisTitleOffset = 12)

setTitle(.Object = valueAxis(), title = "Hello !")

}

