/*
 * Decompiled with CFR 0.152.
 */
package org.ipea.r5r;

import com.conveyal.r5.profile.StreetMode;
import com.conveyal.r5.streets.EdgeStore;
import com.conveyal.r5.streets.VertexStore;
import com.conveyal.r5.transit.TransportNetwork;
import java.util.HashSet;
import org.ipea.r5r.RDataFrame;

public class StreetNetwork {
    public RDataFrame verticesTable;
    public RDataFrame edgesTable;
    private final HashSet<Integer> verticesSet = new HashSet();

    public StreetNetwork(TransportNetwork transportNetwork) {
        this.buildEdgesTable(transportNetwork);
        this.buildVerticesTable(transportNetwork);
    }

    private void buildEdgesTable(TransportNetwork transportNetwork) {
        this.edgesTable = new RDataFrame();
        this.edgesTable.addIntegerColumn("from_vertex", 0);
        this.edgesTable.addIntegerColumn("to_vertex", 0);
        this.edgesTable.addDoubleColumn("length", 0.0);
        this.edgesTable.addBooleanColumn("walk", false);
        this.edgesTable.addBooleanColumn("bicycle", false);
        this.edgesTable.addBooleanColumn("car", false);
        this.edgesTable.addStringColumn("geometry", "");
        EdgeStore edges = transportNetwork.streetLayer.edgeStore;
        EdgeStore.Edge edgeCursor = edges.getCursor();
        while (edgeCursor.advance()) {
            if (edgeCursor.getFlag(EdgeStore.EdgeFlag.LINK)) continue;
            this.edgesTable.append();
            this.edgesTable.set("from_vertex", edgeCursor.getFromVertex());
            this.edgesTable.set("to_vertex", edgeCursor.getToVertex());
            this.edgesTable.set("length", edgeCursor.getLengthM());
            this.edgesTable.set("walk", edgeCursor.allowsStreetMode(StreetMode.WALK));
            this.edgesTable.set("bicycle", edgeCursor.allowsStreetMode(StreetMode.BICYCLE));
            this.edgesTable.set("car", edgeCursor.allowsStreetMode(StreetMode.CAR));
            this.edgesTable.set("geometry", edgeCursor.getGeometry().toString());
            this.verticesSet.add(edgeCursor.getFromVertex());
            this.verticesSet.add(edgeCursor.getToVertex());
        }
    }

    private void buildVerticesTable(TransportNetwork transportNetwork) {
        this.verticesTable = new RDataFrame();
        this.verticesTable.addIntegerColumn("index", 0);
        this.verticesTable.addDoubleColumn("lat", 0.0);
        this.verticesTable.addDoubleColumn("lon", 0.0);
        this.verticesTable.addBooleanColumn("park_and_ride", false);
        this.verticesTable.addBooleanColumn("bike_sharing", false);
        VertexStore vertices = transportNetwork.streetLayer.vertexStore;
        VertexStore.Vertex vertexCursor = vertices.getCursor();
        this.verticesSet.forEach(v -> {
            vertexCursor.seek(v.intValue());
            this.verticesTable.append();
            this.verticesTable.set("index", vertexCursor.index);
            this.verticesTable.set("lat", vertexCursor.getLat());
            this.verticesTable.set("lon", vertexCursor.getLon());
            this.verticesTable.set("park_and_ride", vertexCursor.getFlag(VertexStore.VertexFlag.PARK_AND_RIDE));
            this.verticesTable.set("bike_sharing", vertexCursor.getFlag(VertexStore.VertexFlag.BIKE_SHARING));
        });
    }
}

