% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fetch_survey.R
\name{fetch_survey}
\alias{fetch_survey}
\title{Download a survey and import it into R}
\usage{
fetch_survey(
  surveyID,
  last_response = deprecated(),
  start_date = NULL,
  end_date = NULL,
  unanswer_recode = NULL,
  unanswer_recode_multi = unanswer_recode,
  include_display_order = TRUE,
  limit = NULL,
  include_questions = NULL,
  save_dir = NULL,
  force_request = FALSE,
  verbose = TRUE,
  label = TRUE,
  convert = TRUE,
  import_id = FALSE,
  time_zone = NULL,
  breakout_sets = TRUE,
  add_column_map = TRUE,
  add_var_labels = TRUE,
  col_types = NULL
)
}
\arguments{
\item{surveyID}{String. Unique ID for the survey you want to download.
Returned as \code{id} by the \link[=all_surveys]{all_surveys} function.}

\item{last_response}{Deprecated.}

\item{start_date}{String. Filter to only exports responses recorded after the
specified date. Accepts dates as character strings in format "YYYY-MM-DD".
Defaults to \code{NULL}.}

\item{end_date}{String. Filter to only exports responses recorded before the
specified date. Accepts dates as character strings in format "YYYY-MM-DD".
Defaults to \code{NULL}.}

\item{unanswer_recode}{Integer. Recode seen but unanswered questions with an
integer-like value, such as 999. Defaults to \code{NULL}.}

\item{unanswer_recode_multi}{Integer. Recode seen but unanswered multi-select
questions with an integer-like value, such as 999. Defaults to value for
\code{unaswer_recode}.}

\item{include_display_order}{Display order information (such as for
surveys with randomization).}

\item{limit}{Integer. Maximum number of responses exported. Defaults to
\code{NULL} (all responses).}

\item{include_questions}{Vector of strings (e.g. c('QID1', 'QID2', 'QID3').
Export only specified questions. Defaults to \code{NULL}.}

\item{save_dir}{String. Directory where survey results will be stored.
Defaults to a temporary directory which is cleaned when your R session is
terminated. This argument is useful if you'd like to store survey results.
The downloaded survey will be stored as an RDS file (see
\code{\link[base:readRDS]{base::readRDS()}}).}

\item{force_request}{Logical. fetch_survey() saves each survey in a temporary
directory so that it can quickly be retrieved later. If force_request is
\code{TRUE}, fetch_survey() always downloads the survey from the API instead
of loading it from the temporary directory. Defaults to \code{FALSE}.}

\item{verbose}{Logical. If \code{TRUE}, verbose messages will be printed to
the R console. Defaults to \code{TRUE}.}

\item{label}{Logical. \code{TRUE} to export survey responses as Choice Text
or \code{FALSE} to export survey responses as values.}

\item{convert}{Logical. If \code{TRUE}, then the
\code{\link[=fetch_survey]{fetch_survey()}} function will convert certain question
types (e.g. multiple choice) to proper data type in R. Defaults to \code{TRUE}.}

\item{import_id}{Logical. If \code{TRUE}, use Qualtrics import IDs instead of
question IDs as column names. Will also alter names in the column map, if
used. Defaults to \code{FALSE}.}

\item{time_zone}{String. A local timezone to determine response date
values. Defaults to \code{NULL} which corresponds to UTC time. See
\href{https://api.qualtrics.com/}{"Dates and Times"} from Qualtrics
for more information on format.}

\item{breakout_sets}{Logical. If \code{TRUE}, then the
\code{\link[=fetch_survey]{fetch_survey()}} function will split multiple
choice question answers into columns. If \code{FALSE}, each multiple choice
question is one column. Defaults to \code{TRUE}.}

\item{add_column_map}{Logical. If \code{TRUE}, then a column map data frame
will be added as an attribute to the main response data frame.
This column map captures Qualtrics-provided metadata associated with the
response download, such as an item description and internal ID's. Defaults to
\code{TRUE}.}

\item{add_var_labels}{Logical. If \code{TRUE}, then the item description from
each variable (equivalent to the one in the column map) will be added as a
"label" attribute using \code{\link[sjlabelled:set_label]{sjlabelled::set_label()}}. Useful for
reference as well as cross-compatibility with other stats packages (e.g.,
Stata, see documentation in \code{sjlabelled}). Defaults to \code{TRUE}.}

\item{col_types}{Optional. This argument provides a way to manually overwrite
column types that may be incorrectly guessed. Takes a \code{\link[readr:cols]{readr::cols()}}
specification. See example below and \code{\link[readr:cols]{readr::cols()}} for formatting
details. Defaults to \code{NULL}. Overwritten by \code{convert = TRUE}.}
}
\description{
Download a Qualtrics survey you own via API and import the survey directly into R.
}
\details{
If the request to the Qualtrics API made by this function fails, the request
will be retried. If you see these failures on a 500 error (such as a 504
error) be patient while the request is retried; it will typically succeed
on retrying. If you see other types of errors, retrying is unlikely to help.
}
\examples{
\dontrun{
# Register your Qualtrics credentials if you haven't already
qualtrics_api_credentials(
  api_key = "<YOUR-API-KEY>",
  base_url = "<YOUR-BASE-URL>"
)

# Retrieve a list of surveys
surveys <- all_surveys()

# Retrieve a single survey
mysurvey <- fetch_survey(surveyID = surveys$id[6])

mysurvey <- fetch_survey(
  surveyID = surveys$id[6],
  save_dir = tempdir(),
  start_date = "2018-01-01",
  end_date = "2018-01-31",
  limit = 100,
  label = TRUE,
  unanswer_recode = 999,
  verbose = TRUE,
  # Manually override EndDate to be a character vector
  col_types = readr::cols(EndDate = readr::col_character())
)

}

}
\seealso{
See \url{https://api.qualtrics.com/} for documentation on
the Qualtrics API.
}
