% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/descriptive_functions.R
\name{estat}
\alias{estat}
\title{Descriptive statistics for continuous variables.}
\usage{
estat(object = NULL, formula = NULL, data = NULL, digits = 2, label = NULL)
}
\arguments{
\item{object}{When chaining, this holds an object produced in the earlier portions of the chain. Most users can safely ignore this argument. See details and examples.}

\item{formula}{A formula with shape: ~ x or ~ x|z (for groups).}

\item{data}{A data frame where the variables in the \code{formula} can be found.}

\item{digits}{Number of digits for rounding (default = 2).}

\item{label}{Label used to display the name of the variable (see examples).}
}
\value{
A data frame with descriptive statistics.
}
\description{
\code{estat} calculates descriptives of numerical variables.
}
\examples{
data(kfm, package = "ISwR")
require(sjlabelled, quietly = TRUE)
kfm <- kfm |>
  var_labels(
    dl.milk = "Breast-milk intake (dl/day)",
    sex = "Sex",
    weight = "Child weight (kg)",
    ml.suppl = "Milk substitute (ml/day)",
    mat.weight = "Maternal weight (kg)",
    mat.height = "Maternal height (cm)"
  )

kfm |>
  estat(~dl.milk)

estat(~ dl.milk | sex, data = kfm)

kfm |>
  estat(~ weight | sex)
}
\seealso{
\code{\link{summary}}.
}
