% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/estimate_var_tsa.R
\name{estimate_var_tsa}
\alias{estimate_var_tsa}
\alias{estimate_var_tsa_meas}
\alias{estimate_var_tsa_uvdrr}
\alias{estimate_var_tsa_bvdrr}
\alias{estimate_var_tsa_uvirr}
\alias{estimate_var_tsa_bvirr}
\alias{estimate_var_tsa_rb1}
\alias{estimate_var_tsa_rb2}
\title{Taylor Series Approximation of effect-size variances corrected for psychometric artifacts}
\usage{
estimate_var_tsa_meas(mean_rtp, var = 0, mean_qx = 1, mean_qy = 1, ...)

estimate_var_tsa_uvdrr(
  mean_rtpa,
  var = 0,
  mean_ux = 1,
  mean_qxa = 1,
  mean_qyi = 1,
  ...
)

estimate_var_tsa_bvdrr(
  mean_rtpa,
  var = 0,
  mean_ux = 1,
  mean_uy = 1,
  mean_qxa = 1,
  mean_qya = 1,
  ...
)

estimate_var_tsa_uvirr(
  mean_rtpa,
  var = 0,
  mean_ut = 1,
  mean_qxa = 1,
  mean_qyi = 1,
  ...
)

estimate_var_tsa_bvirr(
  mean_rtpa,
  var = 0,
  mean_ux = 1,
  mean_uy = 1,
  mean_qxa = 1,
  mean_qya = 1,
  sign_rxz = 1,
  sign_ryz = 1,
  ...
)

estimate_var_tsa_rb1(
  mean_rtpa,
  var = 0,
  mean_ux = 1,
  mean_rxx = 1,
  mean_ryy = 1,
  ...
)

estimate_var_tsa_rb2(
  mean_rtpa,
  var = 0,
  mean_ux = 1,
  mean_qx = 1,
  mean_qy = 1,
  ...
)
}
\arguments{
\item{mean_rtp}{Mean corrected correlation.}

\item{var}{Variance to be corrected for artifacts.}

\item{mean_qx}{Mean square root of reliability for X.}

\item{mean_qy}{Mean square root of reliability for Y.}

\item{...}{Additional arguments.}

\item{mean_rtpa}{Mean corrected correlation.}

\item{mean_ux}{Mean observed-score u ratio for X.}

\item{mean_qxa}{Mean square root of unrestricted reliability for X.}

\item{mean_qyi}{Mean square root of restricted reliability for Y.}

\item{mean_uy}{Mean observed-score u ratio for Y.}

\item{mean_qya}{Mean square root of unrestricted reliability for Y.}

\item{mean_ut}{Mean true-score u ratio for X.}

\item{sign_rxz}{Sign of the relationship between X and the selection mechanism.}

\item{sign_ryz}{Sign of the relationship between Y and the selection mechanism.}

\item{mean_rxx}{Mean reliability for X.}

\item{mean_ryy}{Mean reliability for Y.}
}
\value{
Vector of variances corrected for mean artifacts via Taylor series approximation.
}
\description{
Functions to estimate the variances corrected for psychometric artifacts.
These functions use Taylor series approximations (i.e., the delta method) to estimate the corrected variance of an effect-size distribution.

The available Taylor-series functions include:
\itemize{
\item{\code{estimate_var_tsa_meas}}{\cr Variance of \eqn{\rho} corrected for measurement error only}
\item{\code{estimate_var_tsa_uvdrr}}{\cr Variance of \eqn{\rho} corrected for univariate direct range restriction (i.e., Case II) and measurement error}
\item{\code{estimate_var_tsa_bvdrr}}{\cr Variance of \eqn{\rho} corrected for bivariate direct range restriction and measurement error}
\item{\code{estimate_var_tsa_uvirr}}{\cr Variance of \eqn{\rho} corrected for univariate indirect range restriction (i.e., Case IV) and measurement error}
\item{\code{estimate_var_tsa_bvirr}}{\cr Variance of \eqn{\rho} corrected for bivariate indirect range restriction (i.e., Case V) and measurement error}
\item{\code{estimate_var_tsa_rb1}}{\cr Variance of \eqn{\rho} corrected using Raju and Burke's TSA1 correction for direct range restriction and measurement error}
\item{\code{estimate_var_tsa_rb2}}{\cr Variance of \eqn{\rho} corrected using Raju and Burke's TSA2 correction for direct range restriction and measurement error. Note that a typographical error in Raju and Burke's article has been corrected in this function so as to compute appropriate partial derivatives.}
}
}
\section{Notes}{

A typographical error in Raju and Burke's article has been corrected in \code{\link[=estimate_var_tsa_rb2]{estimate_var_tsa_rb2()}} so as to compute appropriate partial derivatives.
}

\examples{
estimate_var_tsa_meas(mean_rtp = .5, var = .02,
                 mean_qx = .8,
                 mean_qy = .8)
estimate_var_tsa_uvdrr(mean_rtpa = .5, var = .02,
                  mean_ux = .8,
                  mean_qxa = .8,
                  mean_qyi = .8)
estimate_var_tsa_bvdrr(mean_rtpa = .5, var = .02,
                  mean_ux = .8,
                  mean_uy = .8,
                  mean_qxa = .8,
                  mean_qya = .8)
estimate_var_tsa_uvirr(mean_rtpa = .5, var = .02,
                  mean_ut = .8,
                  mean_qxa = .8,
                  mean_qyi = .8)
estimate_var_tsa_bvirr(mean_rtpa = .5, var = .02,
                  mean_ux = .8,
                  mean_uy = .8,
                  mean_qxa = .8,
                  mean_qya = .8,
                  sign_rxz = 1, sign_ryz = 1)
estimate_var_tsa_rb1(mean_rtpa = .5, var = .02,
                mean_ux = .8,
                mean_rxx = .8,
                mean_ryy = .8)
estimate_var_tsa_rb2(mean_rtpa = .5, var = .02,
                mean_ux = .8,
                mean_qx = .8,
                mean_qy = .8)
}
\references{
Dahlke, J. A., & Wiernik, B. M. (2020). Not restricted to selection research:
Accounting for indirect range restriction in organizational research.
\emph{Organizational Research Methods, 23}(4), 717–749. \doi{10.1177/1094428119859398}

Hunter, J. E., Schmidt, F. L., & Le, H. (2006).
Implications of direct and indirect range restriction for meta-analysis methods and findings.
\emph{Journal of Applied Psychology, 91}(3), 594–612. \doi{10.1037/0021-9010.91.3.594}

Raju, N. S., & Burke, M. J. (1983). Two new procedures for studying validity generalization.
\emph{Journal of Applied Psychology, 68}(3), 382–395. \doi{10.1037/0021-9010.68.3.382}
}
