% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/handleNA.R
\name{heatmap_na}
\alias{heatmap_na}
\title{Visualize missing data}
\usage{
heatmap_na(
  raw_df,
  protein_range,
  sample_range,
  reorder_x = FALSE,
  reorder_y = FALSE,
  x_fun = mean,
  y_fun = mean,
  palette = "viridis",
  label_proteins = FALSE,
  text_size = 10,
  save = FALSE,
  file_type = "pdf",
  file_path = NULL,
  file_name = "Missing_data_heatmap",
  plot_width = 15,
  plot_height = 15,
  dpi = 80
)
}
\arguments{
\item{raw_df}{A \code{raw_df} object (output from \code{\link{create_df}}).}

\item{protein_range}{The range of proteins to plot. Default is \code{ALL},
meaning all the proteins in the data frame.}

\item{sample_range}{The range of samples to plot. Default is \code{ALL},
meaning all the samples in the data frame.}

\item{reorder_x}{Logical. If \code{TRUE} samples on the x axis are reordered
using the function given in \code{x_fun}. Default is \code{FALSE}.}

\item{reorder_y}{Logical. If \code{TRUE} proteins in the y axis are reordered
using the function given in \code{y_fun}. Default is \code{FALSE}.}

\item{x_fun}{Function to reorder samples along the x axis. Possible options
are \code{mean} and \code{sum}. Default is \code{mean}.}

\item{y_fun}{Function to reorder proteins along the y axis. Possible options
are \code{mean} and \code{sum}. Default is \code{mean}.}

\item{palette}{Viridis color palette option for plots. Default is
\code{"viridis"}. See
\code{\link[viridisLite:viridis]{viridis}}
for available options.}

\item{label_proteins}{If \code{TRUE} proteins on the y axis
will be labeled with their Majority Protein IDs. Defualt is \code{FALSE}.}

\item{text_size}{Text size for axis labels. Default is \code{10}.}

\item{save}{Logical. If \code{TRUE} saves a copy of the plot in the
directory provided in \code{file_path}.}

\item{file_type}{File type to save the heatmap. Default is \code{"pdf"}.}

\item{file_path}{A string containing the directory path to save the file.}

\item{file_name}{File name to save the heatmap. Default is
\code{"Missing_data_heatmap"}.}

\item{plot_width}{Width of the plot. Default is \code{15}.}

\item{plot_height}{Height of the plot. Default is \code{15}.}

\item{dpi}{Plot resolution. Default is \code{80}.}
}
\value{
A \code{ggplot2} plot object.
}
\description{
This function visualizes the patterns of missing value
occurrence using a heatmap.
}
\details{
This function visualizes patterns of missing value occurrence using a
heatmap. The user can choose to reorder the axes using the available functions
(\code{x_fun}, \code{y_fun}) to better understand the underlying cause of
missing data.
}
\examples{
## Generate a raw_df object with default settings. No technical replicates.
raw_df <- create_df(
prot_groups = "https://raw.githubusercontent.com/caranathunge/promor_example_data/main/pg1.txt",
exp_design = "https://raw.githubusercontent.com/caranathunge/promor_example_data/main/ed1.txt"
)

## Missing data heatmap with default settings.
heatmap_na(raw_df)

## Missing data heatmap with x and y axes reordered by the mean (default) of
## protein intensity.
heatmap_na(raw_df,
  reorder_x = TRUE, reorder_y = TRUE
)

## Missing data heatmap with x and y axes reordered by the sum of
## protein intensity.
heatmap_na(raw_df,
  reorder_x = TRUE, reorder_y = TRUE, x_fun = sum,
  y_fun = sum
)

## Missing data heatmap for a subset of the proteins with x and y axes
## reordered by the mean (default) of protein intensity and the y axis
## labeled with protein IDs.
heatmap_na(raw_df,
  protein_range = 1:30,
  reorder_x = TRUE, reorder_y = TRUE,
  label_proteins = TRUE
)

}
\seealso{
\code{\link{create_df}}
}
\author{
Chathurani Ranathunge
}
